// Лаборатория электроники и программирования
// Эксперимент 43
// Часы на DS3231 и 4-х разрядной светодиодной матрице
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>
#include <Wire.h>
#include <DS1307RTC.h>
#include <Time.h>
#include <TimeLib.h>
// пин CS
int pinCS = 9;
// количество матриц по-горизонтали
int numberOfHorizontal = 4; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// текст для вывода ошибки
String texterror = "Ok95!";
unsigned long millist=0;
// переменная времени
tmElements_t datetime;
// показ разделителя
boolean blinkview=true;

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(7); 
}

void loop() {
  // прошло 500 мсек?
  if(millis()-millist>=500) {
     millist=millis();
     // получение данных из ds3231
     if (RTC.read(datetime))  {
        matrix.setRotation( 0, 1 );
        matrix.drawChar(1, 0, datetime.Hour/10+0x30, HIGH, LOW, 1);
        matrix.setRotation( 1, 1 );
        matrix.drawChar(9, 0, datetime.Hour%10+0x30, HIGH, LOW, 1);
        matrix.setRotation( 2, 1 );
        matrix.drawChar(17, 0, datetime.Minute/10+0x30, HIGH, LOW, 1);
        matrix.setRotation( 3, 1 );
        matrix.drawChar(25, 0, datetime.Minute/10+0x30, HIGH, LOW, 1);
        matrix.write();
        // разделитель
        matrix.drawPixel(15, 2, blinkview);
        matrix.drawPixel(15, 5, blinkview);
        blinkview=!blinkview;
     }
     else {
        for ( int i = 0 ; i < texterror.length(); i++ ) {
           matrix.setRotation( i, 1 );
           matrix.drawChar(i*6, 0, texterror[i], HIGH, LOW, 1);
        } 
        matrix.write();
    }
  }
  
}
