// Лаборатория электроники и программирования
// Эксперимент 43
// Часы на DS3231 и 4-х разрядной светодиодной матрице
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>
#include <Wire.h>
#include <DS1307RTC.h>
#include <Time.h>
#include <TimeLib.h>
// пин CS
int pinCS = 9;
// количество матриц по-горизонтали
int numberOfHorizontal = 15; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// текст для вывода ошибки
String text ="";
unsigned long millist=0;
// переменная времени
tmElements_t datetime;
// показ разделителя
boolean blinkview=true;
// текущий режим
// 0 - hh:ss
// 1 - hh:ss --> dd/mm
// 2 - dd:mm
// 3 - dd:mm --> YYYY
// 4 - YYYY
// 5 - YYYY --> Wday
// 6 - Wday
// 7 - Wday --> dd/mm

int pos=0;
// для отсчета времени
unsigned long millispos=0;
String weekdays[]={
     {"Sun "},{"Mon "},{"Tue "},{"Wed "},
     {"Thu "},{"Fri "},{"Sat "}
};
// разделители
int bl0[]={0,0,1,0,0,1,0,0};
int bl1[]={0,0,1,1,1,0,0,0};

void setup() {
    Serial.begin(9600);
    // яркость от 0 до 15
    matrix.setIntensity(7); 
}


void loop() {
  switch(pos) {
    case 0: 
            millispos=millis();
            while(millis()-millispos<4000) {
               if(millis()-millist>=500) {
                  millist=millis();
                  RTC.read(datetime);
                  text="";
                  text+=char(datetime.Hour/10+0x30);
                  text+=char(datetime.Hour%10+0x30);
                  text+=char(datetime.Minute/10+0x30);
                  text+=char(datetime.Minute%10+0x30);
                  viewData(text,bl0,blinkview); 
                  blinkview=!blinkview;
               }
            }
            pos=1;
            Serial.println("pos=1");
       break;
    case 1: 
             RTC.read(datetime);
             text="";
             text+=char(datetime.Hour/10+0x30);
             text+=char(datetime.Hour%10+0x30);
             text+=char(datetime.Minute/10+0x30);
             text+=char(datetime.Minute%10+0x30);
             text+="  ";
             text+=char(datetime.Day/10+0x30);
             text+=char(datetime.Day%10+0x30);
             text+=char(datetime.Month/10+0x30);
             text+=char(datetime.Month%10+0x30);
             viewrunningData(text,20);
             pos=2;
             Serial.println("pos=2");
       break;
    case 2: 
            millispos=millis();
            while(millis()-millispos<3000) {
               if(millis()-millist>=500) {
                  millist=millis();
                  RTC.read(datetime);
                  text="";
                  text+=char(datetime.Day/10+0x30);
                  text+=char(datetime.Day%10+0x30);
                  text+=char(datetime.Month/10+0x30);
                  text+=char(datetime.Month%10+0x30);
                  viewData(text,bl1,1); 
               }
            }
            pos=3;
            Serial.println("pos=3");
       break;
    case 3: 
             RTC.read(datetime);
             text="";
             text+=char(datetime.Day/10+0x30);
             text+=char(datetime.Day%10+0x30);
             text+=char(datetime.Month/10+0x30);
             text+=char(datetime.Month%10+0x30);
             text+="  ";
             text+=String(tmYearToCalendar(datetime.Year));
             viewrunningData(text,20);
             pos=4;
             Serial.println("pos=4");
       break;
    case 4: 
            millispos=millis();
            while(millis()-millispos<3000) {
               if(millis()-millist>=500) {
                  millist=millis();
                  RTC.read(datetime);
                  text=String(tmYearToCalendar(datetime.Year));
                  viewData(text,bl1,0); 
               }
            }
            pos=5;
            Serial.println("pos=5");
       break;
    case 5: 
             RTC.read(datetime);
             text="";
             text+=String(tmYearToCalendar(datetime.Year));
             text+="  ";
             text+=weekdays[datetime.Wday-1];
             viewrunningData(text,20);
             pos=6;
             Serial.println("pos=6");
       break;
    case 6: 
            millispos=millis();
            while(millis()-millispos<3000) {
               if(millis()-millist>=500) {
                  millist=millis();
                  RTC.read(datetime);
                  Serial.println(datetime.Wday);
                  Serial.println(weekdays[datetime.Wday]);
                  text=weekdays[datetime.Wday-1];
                  viewData(text,bl1,0); 
               }
            }
            pos=7;
            Serial.println("pos=7");
       break;
    case 7: 
             RTC.read(datetime);
             text="";
             text+=weekdays[datetime.Wday-1];
             text+="  ";
             text+=char(datetime.Hour/10+0x30);
             text+=char(datetime.Hour%10+0x30);
             text+=char(datetime.Minute/10+0x30);
             text+=char(datetime.Minute%10+0x30);
             viewrunningData(text,20);
             pos=0;
             Serial.println("pos=0");
       break;
    default: 
       break;       
  } 
}
// вывод неподвижного текста
void viewData(String txt,int m[8],boolean f) {
   Serial.println(txt);
   // вывод текста
   for ( int i = 0 ; i < txt.length(); i++ ) {
      matrix.setRotation( i, 1 );
      matrix.drawChar(i*8+2, 0, txt[i], HIGH, LOW, 1);
   } 
   // вывод разделителя
   for(int i=0;i<8;i++) {
      matrix.drawPixel(16, i, m[i]&f);
   }
   matrix.write();
}
// вывод бегущей строки
void viewrunningData(String txt,int speedstr) {
   int offset=0;
   Serial.println(txt);
   // 48 шагов
   for(int offset=0;offset<48;offset++) {
      matrix.fillScreen(LOW);
      // вывод строки с позиции offset
      for ( int i = 0 ; i < txt.length(); i++ ) {
         matrix.setRotation( i, 1 );
         matrix.drawChar(i*8-offset+1, 0, txt[i], HIGH, LOW, 1);
      }
      matrix.write();
      delay(speedstr);    
   }    
}

