// Лаборатория электроники и программирования
// Эксперимент 46
// Часы на DS3231 и ЖК дисплее LCD Keypad shield
// Добавляем будильники
//

// подключение библиотек
#include <Wire.h>
#include <DS1307RTC.h>
#include <Time.h>
#include <TimeLib.h>
#include <LiquidCrystal.h>
// создание экземпляра дисплея
LiquidCrystal lcd(8,9,4,5,6,7);
// переменная времени-даты
tmElements_t datetime;  
// массив дней недели
String weekdays[]={
     {"  Sunday  "},{"  Monday  "},{" Tuesday  "},{"Wednesday "},
     {" Thursday "},{"  Friday  "},{" Saturday "}
};
// для смены данных второй строки
boolean week=false;
unsigned long millis1=0;
// структура, описывающая будильник
struct ALARM{
  int Hour;       // час срабатывания будильника
  int Minute;     // минута срабатывания будильника
  int Day;         // день срабатывания будильника
  int Month;       // месяц срабатывания будильника
  int Year;        // год срабатывания будильника
  boolean repeat;  // true – повторять, false -одноразово 
  int wdays[7];    // дни недели
};
// список будильников
ALARM alarms[]={{7,30,10,10,2018,1,{1,1,1,1,1,0,0}},
                {11,16, 14,12,2018,0,{0,0,0,0,0,0,0}},
                {11,20, 10,11,2018,1,{1,1,1,1,1,0,0}},
                {22,10, 10,12,2018,1,{1,1,1,1,1,1,1}},
              };
// будильник работает?
boolean alarmyes=false;
// пин подключения динамика
int pinSpeaker=10;

void setup() {
   Serial.begin(9600); 
   // запуск дисплея
   lcd.begin(16,2);
   // вывод заставки
   lcd.setCursor(3,0);
   lcd.print("Clock DS3231");
   lcd.setCursor(2,1);
   lcd.print("Arduino-kit.ru");
   delay(3000);
   lcd.clear();
   // пин динамика
   pinMode(pinSpeaker,OUTPUT);
}

void loop() {
   // выключение будильника
   if(alarmyes==true) {
      if(analogRead(A0)<100) { // кнопка RIGHT нажата?
         alarmyes=false;
         noTone(pinSpeaker);
         Serial.println("ALARM STOP");   
      }
   }
   
   // получение данных из ds3231
   if (RTC.read(datetime))  {
      // время HH:mm:ss
      lcd.setCursor(4,0);
      lcd.print(print2(datetime.Hour, ":"));
      lcd.print(print2(datetime.Minute, ":"));
      lcd.print(print2(datetime.Second, " "));
      // дата или день недели
      lcd.setCursor(3,1);
      Serial.println();
      if(week) { // день недели
         lcd.print(weekdays[datetime.Wday]);
      }
      else {    // дата dd/mm/YYYY
         lcd.print(print2(datetime.Day, "/"));
         lcd.print(print2(datetime.Month, "/"));
         lcd.print(tmYearToCalendar(datetime.Year));
      }
      // изменение week каждые 5 секунд
      if(millis()-millis1>5000) {
         week=!week;
         millis1=millis();
      // проверка времение срабатывания будильника
      isalarm();
      }
   }
   else {
         lcd.print("error");
         delay(5000);
   }
   delay(1000);
}
String print2(int nn,String str) {
   String s="";
   if (nn >= 0 && nn < 10) 
      { s=s+"0";}
   s=s+String(nn);
   s=s+str;
   return s;
}
// проверка времение срабатывания будильника
void isalarm() {
   // проход по всем будильникам
   for(int i=0;i<4;i++) {
       if(alarms[i].repeat==false) { //одноразовый
          if(tmYearToCalendar(datetime.Year)==alarms[i].Year &&
             datetime.Month==alarms[i].Month &&
             datetime.Day==alarms[i].Day &&
             datetime.Hour==alarms[i].Hour &&
             datetime.Minute==alarms[i].Minute &&
             datetime.Second<2) {
             tone(pinSpeaker,349,30000);
             alarmyes=true;  
             Serial.println("ALARM OK");   
          }
       }
       else {
          if(alarms[i].wdays[datetime.Wday]==1 &&
             datetime.Hour==alarms[i].Hour &&
             datetime.Minute==alarms[i].Minute &&
             datetime.Second<3) {
             tone(pinSpeaker,349,30000);
             alarmyes=true;     
             Serial.println("ALARM OK1");   
          }
       }   
   }
}

