// подключение библиотек
#include <SPI.h>
#include <MFRC522.h>
// пины для RST и SS
#define RST_PIN         9           
#define SS_PIN          10          
// создание объекта
MFRC522 mfrc522(SS_PIN, RST_PIN); 
// код наших карт 3579
byte cardKod[4] = {0x33,0x35,0x37,0x39}; 
// баланс карты
unsigned int balance=0; 
// для  считывания UID
byte cardUID[4] = {0,0,0,0};
byte buffer1[18];
byte block = 5;
byte len = 18;
MFRC522::StatusCode status;
MFRC522::MIFARE_Key key;


void setup() {
  Serial.begin(9600); 
  SPI.begin();               
  mfrc522.PCD_Init();
  Serial.println(" Start MRF ");
}

void loop() {
  // Проверка поднесена ли карта
  if ( mfrc522.PICC_IsNewCardPresent()) {
     // 
     if ( mfrc522.PICC_ReadCardSerial()) {
         Serial.print(F("Card UID:"));    
         // сохранить UID
         for (byte i = 0; i < 4; i++) {
             cardUID[i]=mfrc522.uid.uidByte[i];
             Serial.print(cardUID[i],HEX);
         }
         for (byte i = 0; i < 6; i++) 
            key.keyByte[i] = 0xFF;
         // аутентификация карты
        status = mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, 4, &key, &(mfrc522.uid)); //line 834 of MFRC522.cpp file
        if (status == MFRC522::STATUS_OK) {
            Serial.print(F("Authentication ok: "));
        }
        Serial.println(mfrc522.GetStatusCodeName(status));
        // чтение данных с сектора 4
        status = mfrc522.MIFARE_Read(block, buffer1, &len);
        if (status == MFRC522::STATUS_OK) {
           Serial.print("Reading ok: ");
           Serial.println(mfrc522.GetStatusCodeName(status));
            Serial.print(F("Reading OK! "));
            // распечатать данные сектора
            for (uint8_t i = 0; i < 16; i++) {
               Serial.print(buffer1[i],HEX);Serial.print(" ");
            }
            Serial.println(" "); 
            // проверка наших карт
            

            // вывод баланса
            balance=(buffer1[2]<<8)+buffer1[2];
            Serial.println(balance); 
            
        }
     delay(1000); 
     mfrc522.PICC_HaltA();
     mfrc522.PCD_StopCrypto1();
     }
  }
}
