// Лаборатория электроники и программирования
// Эксперимент 11
// Матрица 4-разрядная из 7-сегментных индикаторов 
// Вывода случайной цифры (0–9) на произвольный регистр матрицы
//

// список выводов Arduino для подключения к разрядам a-g
// семисегментного индикатора
int pins[8]={9,13,4,6,7,10,3,5};
// значения для вывода цифр 0-9
byte numbers[10] = { B11111100,   // 0
                     B01100000,   // 1
                     B11011010,   // 2
                     B11110010,   // 3
                     B01100110,   // 4
                     B10110110,   // 5
                     B10111110,   // 6
                     B11100000,   // 7
                     B11111110,   // 8
                     B11100110    // 9
};
// переменная для хранения значения текущей цифры
// семисегментного индикатора
int number=0;
// список выводов Arduino для выбора матрицы 0-3 
int pindigits[4]={2,8,11,12};
// переменная для хранения текущего разряда
int digit=0;

void setup() {
   // Сконфигурировать контакты как выходы
   for(int i=0;i<8;i++)
      pinMode(pins[i],OUTPUT);
   for(int i=0;i<4;i++) {
      pinMode(pindigits[i],OUTPUT);
      digitalWrite(pindigits[i],HIGH);
   }
}

void loop() {
   number=random(0,10);
   // установить выводы a-g
   setNumber(number); 
   // отключить все матрицы 
   for(int i=0;i<4;i++)
      digitalWrite(pindigits[i],HIGH);
   // получить номер матрицы
   digit=random(0,4);
   // включить выбранную матрицу
   digitalWrite(pindigits[digit],LOW);
   // пауза 1 сек
   delay(1000);
}
// функция вывода цифры на семисегментный индикатор
void setNumber(int num) {
   for(int i=0;i<7;i++) {
      if(bitRead(numbers[num],7-i)==HIGH) // зажечь сегмент
         digitalWrite(pins[i],HIGH);
      else // потушить сегмент
         digitalWrite(pins[i],LOW);
   }
}

