// Лаборатория электроники и программирования
// Эксперимент 22
// Матричная клавиатура 4x4 
//

// подключение библиотеки
#include <Keypad.h>
// размеры клавиатуры 4x4
const byte ROWS = 4; 
const byte COLS = 4; 
// символы для клавиш
char keys[ROWS][COLS] = {
{'1','2','3','A'},
{'4','5','6','B'},
{'7','8','9','C'},
{'*','0','#','D'}
};
// контакты считывания
byte rowPins[ROWS] = {9, 8, 7, 6}; 
// контакты подачи 1
byte colPins[COLS] = {5, 4, 3, 2}; 
// создание объекта
Keypad kpd = Keypad( makeKeymap(keys), rowPins, colPins, 
                        ROWS, COLS );
// для формирования сообщений
String msg;


void setup() {
    // запуск последовательного порта
    Serial.begin(9600);
    msg = "";
    // длинное нажатие - 5 сек
    kpd.setHoldTime(5000);
}

void loop() {
    if (kpd.getKeys())
    {
        // сканирование массива состояний кнопок
        for (int i=0; i<LIST_MAX; i++)   
        {
            // только с измененным статусом
            if ( kpd.key[i].stateChanged )   
            {
              // получение состояния клавиш
              // IDLE, PRESSED, HOLD, or RELEASED
                switch (kpd.key[i].kstate) {  
                    case PRESSED:
                    msg = " PRESSED.";
                break;
                    case HOLD:
                    msg = " HOLD.";
                break;
                    case RELEASED:
                    msg = " RELEASED.";
                break;
                    case IDLE:
                    msg = " IDLE.";
                }
                // вывод состояния кнопок
                Serial.print("Key ");
                Serial.print(kpd.key[i].kchar);
                Serial.print("   ");
                Serial.print(kpd.key[i].kcode);
                Serial.println(msg);
            }
        }
    }
}  
