// Лаборатория электроники и программирования
// Эксперимент 30
// Русификация бегущей строки на 4-х разрядной светодиодной матрице
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>
// пин CS
int pinCS = 10;
// количество матриц по-горизонтали
int numberOfHorizontal = 15; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// строка для вывода
String text = "Ардуино-КИТ 2019!";
// текущее смещение от 0
int offset=32;
// максимальное значение скорости
int maxspeed1=100;
// минимальное значение скорости
int minspeed1=1000;

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(7); 
}

void loop() {
    String textnew=utf8rus(text);
    // очистка экрана
    matrix.fillScreen(LOW);
    // вывод строки с позиции offset
    for ( int i = 0 ; i < textnew.length(); i++ ) {
        matrix.setRotation( i, 1 );
        if(i*6+offset>(-6) && i*6+offset<32) {
            matrix.drawChar(i*6+offset, 0, textnew[i], HIGH, LOW, 1);
        }    
    }
    matrix.write();
    // задержка (скорость)
    int speed1=(analogRead(A0),0,1023,minspeed1,maxspeed1);
    delay(speed1);
    // изменение смещения
    offset=offset-1;
    // в начало - позиция 32
    if(offset+text.length()*6==0)
       offset=32;
}

String utf8rus(String source)
{
  int i,k;
  String target;
  unsigned char n;
  char m[2] = { '0', '\0' };

  k = source.length(); i = 0;

  while (i < k) {
    n = source[i]; i++;

    if (n >= 0xC0) {
      switch (n) {
        case 0xD0: {
          n = source[i]; i++;
          if (n == 0x81) { n = 0xA8; break; }
          if (n >= 0x90 && n <= 0xBF) n = n + 0x2F;
          break;
        }
        case 0xD1: {
          n = source[i]; i++;
          if (n == 0x91) { n = 0xB8; break; }
          if (n >= 0x80 && n <= 0x8F) n = n + 0x6F;
          break;
        }
      }
    }
    m[0] = n; target = target + String(m);
  }
return target;
}
