// Лаборатория электроники и программирования
// Эксперимент 32
// Визуализация показаний аналогового двухкоординатного
// джойстика на одной светодиодной матрице (7x7)
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>

int pinCS = 10;
// количество матриц по-горизонтали
int numberOfHorizontal = 1; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// пины подключения джойстика
int pinX = A0;
int pinY = A1;
// переменные
int x, y, x1, x2, y1, y2;

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(8); 
}

void loop() { 
    // получение данных с джойстика и масштабирование
    x=analogRead(pinX);
    y=analogRead(pinY);
    x=map(x,0,1023,0,7);
    y=map(y,0,1023,0,7);
    // очищение матрицы
    matrix.fillScreen(LOW);
    // вычисление от и до для for
    x1=min(3,x);
    x2=max(3,x);
    y1=min(3,y);
    y2=max(3,y);     
    // зажигание пикселей
    for(int i1=x1;i1<=x2;i1++) { 
      for(int i2=y1;i2<=y2;i2++) {
         matrix.drawPixel(i1, i2, HIGH); 
      }
    }
    // вывод всех пикселей на матрицы
    matrix.write(); 
    delay(100);
}
