// Лаборатория электроники и программирования
// Эксперимент 47
// Изменение данных будильников для часов в EEPROM
// по последовательному порту
//

// подключение библиотек
#include <EEPROM.h>
// данные, пришедшие из последовательного порта
String inputString = "";        
// строка пришла
boolean stringComplete = false;  

void setup() {
   // запуск последовательного порта 
   Serial.begin(9600);
   // резервирование 50 bytes для inputString:
   inputString.reserve(50);
   Serial.println("wait.....");
}

void loop() {
    // проверка прихода строки из последовательного порта
    if (stringComplete) {
       Serial.println(inputString);
       // обработка строки
       parse();
       // очистить строку
       inputString = "";
       stringComplete = false;
       Serial.println("wait.....");
    }
}
// получение данных по последовательному порту
void serialEvent() {
  boolean flag1=false;
  
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    // добавление в строку
    inputString += inChar;
    if (inChar == '$') {
      stringComplete = true;
      flag1=true;
    }
  }
}
// парсинг поступивших данных
void parse() {
   int data[15];
   int index=0;
   String str1="";
   unsigned int count;
   
   // очистить
   for(int i=0;i<15;i++) {
      data[i]=0;
   }
   for(int i=0;i<inputString.length();i++) {
      if(inputString[i]==';' || inputString[i]=='$') {
         data[index]=str1.toInt();
         str1="";
         index++;
      }
      else {
         str1=str1+inputString[i];
      }         
   }
   // выполнить команды
   count=EEPROM.read(0);
   switch(data[0]) {
      case 1:  Serial.println("OK");
               // добавление будильника
               count=EEPROM.read(0);
               EEPROM.write(count*14+1,data[1]);
               EEPROM.write(count*14+2,data[2]);
               EEPROM.write(count*14+3,data[3]);
               EEPROM.write(count*14+4,data[4]);
               EEPROM.write(count*14+5,highByte(data[5]));
               EEPROM.write(count*14+6,lowByte(data[5]));
               EEPROM.write(count*14+7,data[6]);
               EEPROM.write(count*14+8,data[7]);
               EEPROM.write(count*14+9,data[8]);
               EEPROM.write(count*14+10,data[9]);
               EEPROM.write(count*14+11,data[10]);
               EEPROM.write(count*14+12,data[11]);
               EEPROM.write(count*14+13,data[12]);
               EEPROM.write(count*14+14,data[13]);
               count++;
               EEPROM.write(0,count);
               Serial.println("add alarm");              
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 2:  Serial.println("OK");
               // удалить если <= count
               if(data[1]<=count && data[1]>0) {
                  // перенести будильники от count до data[1]
                  for(int i=data[1];i<count;i++) {
                     for(int j=1;j<15;j++) {
                        EEPROM.write((i-1)*14+j,EEPROM.read(i*14+j));
                     }
                  }
                  count--;
                  EEPROM.write(0,count);
                  Serial.println("delete alarm"); 
               }
               else {
                  Serial.println("delete alarm ERROR !"); 
               }
               Serial.println("delete alarm");              
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 3:  Serial.println("OK");
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 4:  Serial.println("OK");
               for(int i=0;i<count;i++) {
                  Serial.print(EEPROM.read(i*14+1));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+2));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+3));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+4));Serial.print(" ");
                  Serial.print((EEPROM.read(i*14+5)<<8)+EEPROM.read(i*14+6));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+7));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+8));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+9));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+10));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+11));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+12));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+13));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+14));Serial.print(" ");
                  Serial.println();
               }
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 5:  Serial.println("OK");
               count=0;
               EEPROM.write(0,count);
               Serial.println("clear alarms");              
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      default:  Serial.println("ERROR");
         break;            
   }   
}

