// Лаборатория электроники и программирования
// Эксперимент 50
// Домашняя метеостанция на BMP280 и DHT11 
// с выводом на экран
// и сохранением данных на SD-карту
//


// подключение библиотек
#include <LiquidCrystal.h>
#include "DHT.h"
#include <Wire.h>
#include <SPI.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BMP280.h>
#include <DS1307RTC.h>
#include <Time.h>
#include <TimeLib.h>
#include <SPI.h>
#include <SD.h>
// пин для подключения датчика DHT
#define DHTPIN 12     
// тип датчика DHT
#define DHTTYPE DHT11   // DHT 11 
// создание экземпляров
Adafruit_BMP280 bmp;
LiquidCrystal lcd(8,9,4,5,6,7); 
DHT dht(DHTPIN, DHTTYPE);
// для опроса 
unsigned long millist=0;
// экземпляр объекта 
File file1;
// пин CS
int pinCS = 10;
//
tmElements_t datetime;
// имя файла текущего дня ymd
String sfilename;
char filename[20];
String record="";

void setup()
{
  // подключение последовательного порта
  Serial.begin(9600); 
  // инициализация дисплея
  lcd.begin(16,2);
  // очистить
  lcd.clear();
  // инициализация карты
  Serial.print("Initializing SD card...");
  pinMode(10, OUTPUT);
  if (!SD.begin(pinCS)) {
     Serial.println("initialization failed!");
     return;
  }
  Serial.println("initialization done."); 
  // запуск датчиков DHT,BMP20
  dht.begin();
  bmp.begin();
}

void loop() {
  if(millis()-millist>=60000)
     { 
     // получение данных 
     int h = dht.readHumidity();
     int t = bmp.readTemperature();
     int p = bmp.readPressure();     
     // вывод на дисплей
     lcd.clear();
     lcd.setCursor(0,0);
     lcd.print("H="); 
     lcd.print(h);lcd.print("%");
     lcd.setCursor(7,0);
     lcd.print("T="); 
     lcd.print(t);lcd.print("*C");
     lcd.setCursor(0,1);
     lcd.print("P= "); 
     lcd.print(p);lcd.print("Pa");
     // получение имени файла
     sfilename=get_file_name();
     sfilename.toCharArray(filename,20);
     //
     file1 = SD.open(filename, FILE_WRITE);
     // получить время H:m
     // создать запись для файла
     record=get_time();
     record+=" ";
     record+=String(h);
     record+=" ";
     record+=String(t);
     record+=" ";
     record+=String(p);
     Serial.println(record);
     file1.println(record);
     file1.close();
     //
     millist=millis();
     }
}

// получение времени дня
String get_time()
 {
  String time1;
  RTC.read(datetime);
  if(datetime.Hour<10)
   time1="0"+String(datetime.Hour,DEC);
  else
   time1=String(datetime.Hour,DEC);
  if(datetime.Minute<10)
   time1+=":0"+String(datetime.Minute,DEC);
  else
   time1+=":"+String(datetime.Minute,DEC);
  return time1;
 }
// получение имени файла для текущего дня
String get_file_name()
 {
  String filename1;
  RTC.read(datetime);
  filename1+=String(tmYearToCalendar(datetime.Year),DEC);
  if(datetime.Month<10)
   filename1+="-0"+String(datetime.Month,DEC);
  else
   filename1+="-"+String(datetime.Month,DEC);
  if(datetime.Day<10)
   filename1+="-0"+String(datetime.Day,DEC);
  else
   filename1+="-"+String(datetime.Day,DEC);
  filename1+=".txt";
  return filename1;
 }

