// Лаборатория электроники и программирования
// Эксперимент 55
// Управление скоростью и направлением движения
// 4-фазного шагового двигателя с ИК пульта
// Вывод информации на LCD Keypad shield
//

// подключение библиотек
#include <LiquidCrystal.h>
#include<AccelStepper.h>
#include <IRremote.h>
// контакты подключения 
#define IN1 10
#define IN2 11
#define IN3 12
#define IN4 13
int RECV_PIN = 2;
// создаем экземпляров объектов 
AccelStepper motor(8, IN1, IN3, IN2, IN4);
LiquidCrystal lcd(8,9,4,5,6,7); 
IRrecv irrecv(RECV_PIN);
decode_results results;
// переменные 
int minSpeed=50;
int maxSpeed=900;
int speed=300;
int stepspeed=50;
int dir=0;
//


void setup(){
  lcd.begin(16,2);
  // очистить
  lcd.clear();
  // запуск датчика DHT
  lcd.setCursor(0,0);
  lcd.print("dir   ");
  lcd.print("0    ");  
  lcd.setCursor(0,1);
  lcd.print("speed ");
  lcd.print(speed);
  // начальные установки
  motor.setMaxSpeed(900.0);
  motor.setAcceleration(100.0);
  motor.setSpeed(200);
  // запуск приемника
  irrecv.enableIRIn();     
}
 
void loop(){
   // получение кода с пульта
   if (irrecv.decode(&results)) {
      Serial.println(results.value, HEX);
      // проверка на коды управления
      switch(results.value) {
         case 0xFFC23D: // вправо (по часовой стрелке)
                dir=-1;
                lcd.setCursor(6,0);
                lcd.print("right");  
                motor.setSpeed(speed*dir);
            break;
         case 0xFF22DD: // влево (против часовой стрелки)
                dir=1;
                lcd.setCursor(6,0);
                lcd.print("left ");  
                motor.setSpeed(speed*dir);
            break;
         case 0xFF629D: // увеличить
                speed=min(maxSpeed,speed+stepspeed);
                motor.setSpeed(speed*dir);
                lcd.setCursor(6,1);lcd.print("     ");  
                lcd.setCursor(6,1);lcd.print(speed);  
            break;
         case 0xFFA857: // уменьшить)
                speed=max(minSpeed,speed-stepspeed);
                motor.setSpeed(speed*dir);
                lcd.setCursor(6,1);lcd.print("     ");  
            break;
         case 0xFF02FD: // стоп
                dir=0;
                lcd.setCursor(6,0);
                lcd.print("0    ");  
            break;
         default: 
            break;
      }
      irrecv.resume(); 
   }   
  // движение мотора
  if(dir!=0)
     motor.runSpeed();
}

   
