// Лаборатория электроники и программирования
// Эксперимент 61
// Запись данных, получаемых по последовательному порту
// в RFID-метку
//

// Подключение библиотек
#include <SPI.h>
#include <MFRC522.h>
// константы подключения контактов SS и RST
#define RST_PIN 9
#define SS_PIN 10
// Инициализация MFRC522
MFRC522 mfrc522(SS_PIN, RST_PIN); 
MFRC522::StatusCode status;
MFRC522::MIFARE_Key key;
// строка для получения данных
String inputString = "";         
// признак конца строки
boolean stringComplete = false; 
// полученная команда
int block=0;
// полученные данные
byte data[16];

void setup() {
   Serial.begin(9600); // инициализация последовательного порта
   SPI.begin(); // инициализация SPI
   mfrc522.PCD_Init(); // инициализация MFRC522
}

void loop() {
  // ждем признака конца строки 
  if (stringComplete) {
    Serial.println(inputString);
    if(parse_data()) {
       Serial.println("get data - OK!");
       Serial.println("Bring the card to the reader");
       Serial.print("Wait 10 sec ");
       if(write_data())
          Serial.println("Write OK");
       else
          Serial.println("Write error");
    }
    else {
       Serial.println("Wrong data");
    }
    // очистить строку
    inputString = "";
    stringComplete = false;
  }

}
// Вывод результата чтения данных в HEX-виде
void dump_byte_array(byte *buffer, byte bufferSize) {
   for (byte i = 0; i < bufferSize; i++) {
      Serial.print(buffer[i] < 0x10 ? " 0" : " ");
      Serial.print(buffer[i], HEX);
   }
}
// запись данных на карту
boolean write_data() {
   unsigned long millis1=millis();
   int sec=10;

   while(sec>0) {
      if(millis()-millis1>=1000) {
         Serial.print(".");
         sec--;
         millis1=millis();
      }
      // Проверка поднесена ли карта
      if ( mfrc522.PICC_IsNewCardPresent()) {
         // Считываем инфо о карте.
         if ( mfrc522.PICC_ReadCardSerial()) {  
            Serial.print(F("Card UID:")); 
            for (byte i = 0; i < 4; i++) {
               mfrc522.uid.uidByte[i];
               Serial.print(mfrc522.uid.uidByte[i],HEX);
            }
            Serial.println();
            //
            Serial.println(F("Authenticating using key A..."));
            for (byte i = 0; i < 6; i++) 
               key.keyByte[i] = 0xFF;
            status = mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, block+4, &key, &(mfrc522.uid));
            if (status != MFRC522::STATUS_OK) {
               Serial.print(F("PCD_Authenticate() failed: "));
               Serial.println(mfrc522.GetStatusCodeName(status));
               return false;
            }
            Serial.println(F("PCD_Authenticate() success: ")); 
            Serial.println("write data to card");
            byte trailerBlock   = 7;
            // Authenticate using key B
            Serial.println(F("Authenticating again using key B..."));
            status = (MFRC522::StatusCode) mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_B, trailerBlock, &key, &(mfrc522.uid));
            if (status != MFRC522::STATUS_OK) {
               Serial.print(F("PCD_Authenticate() false: "));
               return false;
            }
            Serial.println(mfrc522.GetStatusCodeName(status));
            // Write data to the block
            Serial.print(F("Writing data into block ")); 
            Serial.print(block+4);
            Serial.println(F(" ..."));
            status = (MFRC522::StatusCode) mfrc522.MIFARE_Write(block+4, data, 16);
            if (status != MFRC522::STATUS_OK) {
               Serial.print(F("MIFARE_Write() false: "));
               return false;
            }
            Serial.println(mfrc522.GetStatusCodeName(status));
         }
      mfrc522.PICC_HaltA();
      mfrc522.PCD_StopCrypto1(); 
      return true;         
      }      
   }
   return false;
}

// парсинг получаемых данных
boolean parse_data() {
   // первый символ
   if(inputString[0]!='*')
       return false;
   if(inputString[2]!=';')
       return false;
   if(inputString[1]<0x31 || inputString[1]>0x33)
       return false;
   block=int(inputString[1]-0x31);
   Serial.print("block=");Serial.println(block);
   for(int i=3;i<inputString.length()-1;i++)
      data[i-3]=inputString[i];  
   // остальное пробелы
   for(int i=inputString.length()-4;i<16;i++)
      data[i]=0x20;  
   // 
   for(int i=0;i<16;i++) {
      Serial.print(data[i],HEX);Serial.print(" "); 
   } 
   Serial.println();
   return true;

}
// получение данных из последовательного порта
void serialEvent() {
  while (Serial.available()) {
    // получить байт
    char inChar = (char)Serial.read();
    // добавить в строку
    inputString += inChar;
    // если символ конца строки - '$'
    if (inChar == '$') {
      stringComplete = true;
    }
  }
}
