// Лаборатория электроники и программирования
// Эксперимент 69
// Сервер на  ESP8266  
// Управление реле, подключенными к Arduino
//

// подключение библиотек
#include <ESP8266WiFi.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта сервера
WiFiServer server(80);
 // данные, пришедшие из последовательного порта
String inputString = "";        
String inputString1 = ""; 
// строка пришла
boolean stringComplete = false;  
// состояние checkbox для led
String checked1="";
String checked2="";

void setup(void){
  delay(5000);
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("*");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());


  // запуск сервера
  server.begin();
  Serial.print("HTTP server started$");
}

void loop(void){

    // подключение клиента
    WiFiClient client = server.available();
    if (client) {
      Serial.println("new client");
      // конец запроса
      boolean currentLineIsBlank = true;
      // собираем данные
      String data="";
      while (client.connected()) {
        if (client.available()) {
          char c = client.read();
          data+=c;
          Serial.write(c);
          if (c == '\n' && currentLineIsBlank) {
            // анализ данных запроса и отправка данных на Arduino
            String toArduino="*";
            if(data.indexOf("relay1=on")!=-1) {
                toArduino+="relay1=on;";checked1="checked";
            }
            else {
               toArduino+="relay1=off;";;checked1="";
            }
            if(data.indexOf("relay2=on")!=-1) {
               toArduino+="relay2=on";checked2="checked";
            }
            else {
               toArduino+="relay2=off";checked2="";
            }
            toArduino+="$";
            Serial.print(toArduino);
            // отправить заголовки и страницу
            client.println("HTTP/1.1 200 OK");
            client.println("Content-Type: text/html");
            client.println("Connection: close");  // the connection will be closed after completion of the response
            client.println();
            client.println("<!DOCTYPE HTML>");
            client.println("<html>");
            client.println("<form name='form1' id='form1' action='' method='GET'>");
            client.println("<br> Relay 1 <input type='checkbox' name='relay1' ");
            client.println(checked1);
            client.println("' onchange='document.getElementById(\"send1\").click();'>");
            client.println("<br> Relay 2 <input type='checkbox' name='relay2' ");
            client.println(checked2);
            client.println("' onchange='document.getElementById(\"send1\").click();'>");
            client.println("<br> <input type='submit' name='send1' id='send1' value='send1' style=\"visibility : hidden\" >");
            client.println("</form>");
            client.println("</html>");
            break;
          }
          if (c == '\n') {
            currentLineIsBlank = true;
          } else if (c != '\r') {
            currentLineIsBlank = false;
          }
        }
      }
      delay(1);
      // закрыть соединение
      client.stop();
      Serial.println("client disconnected");
    }    
  
}


