// Лаборатория электроники и программирования
// Эксперимент 72
// Отправка данных с датчиков
// домашней метеостанции (BMP280 и DHT11) 
// на ESP8266 для отправки на сайт
// Народного мониторинга
//


// подключение библиотек
#include "DHT.h"
#include <Wire.h>
#include <SPI.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>
// пин для подключения датчика DHT
#define DHTPIN 10     
// тип датчика DHT
#define DHTTYPE DHT11   // DHT 11 
// создание экземпляров
Adafruit_BME280 bmp;
DHT dht(DHTPIN, DHTTYPE);
// для опроса
unsigned long millissend=0;
unsigned long pauseseconds=10;
// ID - устройства в Народном мониторинге
String IDstr="441369430175";

void setup()
{
  // подключение последовательного порта
  Serial.begin(115200); 
  // запуск датчиков DHT,BMP20
  dht.begin();
  bmp.begin();
}

void loop() {
  // ждем время паузы
  if(millis()-millissend>=1000) {
     pauseseconds--;
     //Serial.print("time to send - ");Serial.println(pauseseconds);
     if(pauseseconds==0) {
        // получение данных 
        int h = dht.readHumidity();
        int t = bmp.readTemperature();
        float p = bmp.readPressure()/133.32;     
        // формирование строки
        String str="/get?ID="+IDstr;
        str=str+"&H1="+String(h);
        str=str+="&T1="+String(t);
        str=str+="&P1="+String(p);
        str=str+="*";
        // отправка в последовательный порт
        Serial.print(str);
        //
        pauseseconds=300;
        }

     millissend=millis();
  }
}


