// Лаборатория электроники и программирования
// Эксперимент 20
// Музыкальный звонок. 
//

// МЕЛОДИЯ – массив нот и массив длительностей
char melody[]={'A', 'E','A','E','A', 'U','G','G','G',
                    'E','U','E','G', 'A','A','A','A',
                    'E','A','E','A', 'U','G','G','G',
                    'E','U','E','G', 'A','A',

                    'H','H','H','H','H', 'c','c','c','c','c',
                    'c','H','A','U', 'A','A','A','A',
                    'H','H','H','H','H', 'c','c','c','c','c',
                    'c','H','A','U', 'A', '*'
};
int bb[]={4, 4,4,4,4, 4,4,4,4,
        4,4,4,4, 4,4,4,4,
        4,4,4,4, 4,4,4,4,
        4,4,4,4, 8,8,

        4,2,2,4,4, 4,2,2,4,4,
        4,4,4,4, 4,4,4,4,
        4,2,2,4,4, 4,2,2,4,4,
        4,4,4,4, 4,64
};
// пин подключения динамика
#define PIN_SPEAKER 4
// переменные - темп воспроизведения, ноты, длительности
int tempo,notes,beats;
#define MIN_TEMPO 20
#define MAX_TEMPO 100
// пин подключения потенциометра
#define PIN_POT A0
// пин подключения кнопки
#define PIN_BUTTON 7
// Переменная для сохранения текущего состояния кнопки
int tekButton = LOW;
// Переменная для сохранения предыдущего состояния
int prevButton = LOW; 

void setup()  {
   // Сконфигурировать контакт динамика как выход
   pinMode(PIN_SPEAKER, OUTPUT);
   // Сконфигурировать контакт кнопки как вход
   pinMode (PIN_BUTTON, INPUT);
}
   
void loop()  {
   tekButton = debounce(prevButton);
   if (prevButton == LOW && tekButton == HIGH) // если нажатие...
      {
      // получить темп воспроизведения
      tempo=map(analogRead(PIN_POT),0,1024,MIN_TEMPO,MAX_TEMPO);
      for(int i=0;i<sizeof(melody);i++)  {
         notes=melody[i];
         beats=bb[i];
         if (notes == '*')
            tone(PIN_SPEAKER,0, beats*tempo); // пауза
         else
            playNote(notes, beats*tempo); // воспроизвести ноту
         // пауза между нотами
         delay(beats*tempo+tempo);
         // проверить на отжатие
         tekButton = debounce(prevButton);
         if (prevButton == HIGH  && tekButton == LOW) {
            i=sizeof(melody); // прекратить
            tekButton == LOW;
         }               
         prevButton = tekButton;
         // получить темп воспроизведения  
         tempo=map(analogRead(PIN_POT),0,1024,MIN_TEMPO,MAX_TEMPO);
     }
   }
   prevButton = tekButton;   
}
// процедура проигрыша ноты
void playNote(char note, int duration) {
   // массив для наименований нот в пределах двух октав
   char names[]={'c','r','d','s','e','f','t','g','u','a','b',
   'h','C','R','D','S','E','F','T','G','U','A','B', 'H','F'};
   // массив частот нот
   int tones[]={261,277,293,311,329,349,370,392,415,440,466,
   494, 523,554,587,622,659,698,740,784,830,880,932,988};
   for (int i = 0; i < sizeof(tones); i++) {
      if (names[i] == note)  {
         tone(PIN_SPEAKER,tones[i],duration);
      }
   }
}
// Функция сглаживания дребезга. 
boolean debounce(boolean last) {
   // Считать состояние кнопки,
   boolean current = digitalRead(PIN_BUTTON); 
   if (last != current) // если изменилось...
      {
      delay(5); // ждем 5 мс
      current = digitalRead(PIN_BUTTON); 
      return current; 
   }
}    

