// Лаборатория электроники и программирования
// Эксперимент 23
// Пианино на матричной клавиатуре 
//

// подключение библиотеки
#include <Keypad.h>
// размеры клавиатуры 4x4
const byte ROWS = 4; 
const byte COLS = 4; 
// символы для клавиш
char keys[ROWS][COLS] = {
{'C','D','E','F'},
{'G','A','B','H'},
{'c','d','e','f'},
{'g','a','b','h'}
};
// контакты считывания
byte rowPins[ROWS] = {9, 8, 7, 6}; 
// контакты подачи 1
byte colPins[COLS] = {5, 4, 3, 2}; 
// создание объекта
Keypad kpd = Keypad( makeKeymap(keys), rowPins, colPins, 
                        ROWS, COLS );
// для формирования сообщений
String msg;
// массив воспроизведения:
int play[16]={16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16};
// количество одновременно нажатых кнопок:
int counts=0;
// список частот для нот:
int freq[]={261,293,329,349,392,440,466,494,
            523,587,659,698,784,880,932,988,0};
// пин подключения динамика
int pinSpeaker=10;

void setup() {
    // запуск последовательного порта
    Serial.begin(9600);
    msg = "";
    // длинное нажатие - 5 сек
    kpd.setHoldTime(5000);
}

void loop() {
    if (kpd.getKeys())
    {
        // сканирование массива состояний кнопок
        for (int i=0; i<LIST_MAX; i++)   
        {
            // только с измененным статусом
            if ( kpd.key[i].stateChanged )   
            {
              // получение состояния клавиш
              // IDLE, PRESSED, HOLD, or RELEASED
                switch (kpd.key[i].kstate) {  
                    case PRESSED:
                    msg = " PRESSED.";
                    shiftAdd(counts);
                    play[0]= kpd.key[i].kcode;
                    counts++;
                    tone(pinSpeaker, freq[play[0]]);
                break;
                    case HOLD:
                    msg = " HOLD.";
                break;
                    case RELEASED:
                    msg = " RELEASED.";
                    shiftDelete(kpd.key[i].kcode,counts);
                    counts--;
                    if(counts>0)
                       {tone(pinSpeaker, freq[play[0]]);}
                    else
                       {noTone(pinSpeaker);}
                break;
                    case IDLE:
                    msg = " IDLE.";
                }
                // вывод состояния кнопок
                Serial.print("Key ");
                Serial.print(kpd.key[i].kchar);
                Serial.print(msg);
                Serial.print("   =");
                Serial.println(counts);
            }
        }
    }
}   
void shiftAdd(int cnt) {
     for(int i=cnt;i>0;i--) {
        play[i]= play[i-1];
       }
}
void shiftDelete(int codeNote, int cnt) {
     for(int i=0;i<cnt;i++) {
        if(play[i]== codeNote)  {
           for(int j=i;j<cnt;j++) {
              play[j]= play[j+1];
           }
        }
     }
}
 
