// Лаборатория электроники и программирования
// Эксперимент 39
// Вывод показаний датчика DHT11 на дисплей 
//


// подключение библиотек
#include <LiquidCrystal.h>
#include "DHT.h"
// пин для подключения датчика DHT
#define DHTPIN 12     
// тип датчика DHT
#define DHTTYPE DHT11   // DHT 11 

// создание экземпляра LiquidCrystal
LiquidCrystal lcd(8,9,4,5,6,7); 
// создание экземпляра DHT
DHT dht(DHTPIN, DHTTYPE);
 


void setup()
{
  // подключение последовательного порта
  Serial.begin(9600); 
  // инициализация дисплея
  lcd.begin(16,2);
  // очистить
  lcd.clear();
  // запуск датчика DHT
  dht.begin();
}


void loop() {
  // получение данных влажности
  float h = dht.readHumidity();
  // получение данных температуры
  float t = dht.readTemperature();
  // вывод на дисплей
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("H= "); 
  lcd.print(h);lcd.print(" %");
  lcd.setCursor(0,1);
  lcd.print("T= "); 
  lcd.print(t);lcd.print(" *C");
  // вывод в последовательный порт
  Serial.print("Humidity= "); 
  Serial.print(h);Serial.print(" %");
  Serial.print("   Temperature= "); 
  Serial.print(t);Serial.println(" *C");
  // не чаще 2 секунд
  delay(2000);
}


