// Лаборатория электроники и программирования
// Эксперимент 53
// Управление скоростью и направлением движения
// 4-фазного шагового двигателя с LCD Keypad shield
//

// подключение библиотек
#include <LiquidCrystal.h>
#include<AccelStepper.h>
// контакты подключения 
#define IN1 10
#define IN2 11
#define IN3 12
#define IN4 13
// создаем экземпляров объектов 
AccelStepper motor(8, IN1, IN3, IN2, IN4);
LiquidCrystal lcd(8,9,4,5,6,7); 
// 
int minSpeed=50;
int maxSpeed=900;
int speed=300;
int stepspeed=50;
int dir=0;
//
unsigned long millisUp=0;
unsigned long millisDown=0;
// переменная для хранения значения A0 
int valA0 = 0; 

void setup(){
  lcd.begin(16,2);
  // очистить
  lcd.clear();
  // запуск датчика DHT
  lcd.setCursor(0,0);
  lcd.print("dir   ");
  lcd.print("0    ");  
  lcd.setCursor(0,1);
  lcd.print("speed ");
  lcd.print(speed);
  // начальные установки
  motor.setMaxSpeed(900.0);
  motor.setAcceleration(100.0);
  motor.setSpeed(200);
}
 
void loop(){
   // чтение данных A0 
   valA0 = analogRead(A0); 
   // определение нажатия кнопок
   if(valA0<80) { // RIGHT
      dir=-1;
      lcd.setCursor(6,0);
      lcd.print("right");  
      motor.setSpeed(speed*dir);
   }
   else if(valA0<200) { 
      if(millis()-millisUp>500) {
         // UP - скорость увеличить
         speed=min(maxSpeed,speed+stepspeed);
         motor.setSpeed(speed*dir);
         lcd.setCursor(6,1);lcd.print("     ");  
         lcd.setCursor(6,1);lcd.print(speed);  
         millisUp=millis();
      }
   }
   else if(valA0<400) { 
      if(millis()-millisDown>500) {
         // DOWN - скорость уменьшить
         speed=max(minSpeed,speed-stepspeed);
         motor.setSpeed(speed*dir);
         lcd.setCursor(6,1);lcd.print("     ");  
         lcd.setCursor(6,1);lcd.print(speed);  
         millisDown=millis();
      }
   }
   else if(valA0<600) { // LEFT
      dir=1;
      lcd.setCursor(6,0);
      lcd.print("left ");  
      motor.setSpeed(speed*dir);
   }
   else if(valA0<800) { // SELECT - останов
      dir=0;
      lcd.setCursor(6,0);
      lcd.print("0    ");  
   }  
  // движение мотора
  if(dir!=0)
     motor.runSpeed();
}

   
