// Лаборатория электроники и программирования
// Эксперимент 57
// Радар  на шаговом двигателе и датчике HC-SR04
//

// подключение библиотек
#include <LiquidCrystal.h>
#include<AccelStepper.h>
#include "Ultrasonic.h"
// контакты подключения 
#define IN1 10
#define IN2 11
#define IN3 12
#define IN4 13
#define PIN_TRIG A2
#define PIN_ECHO A3
// создаем экземпляров объектов 
AccelStepper motor(8, IN1, IN3, IN2, IN4);
LiquidCrystal lcd(8,9,4,5,6,7); 
Ultrasonic ultrasonic(PIN_TRIG, PIN_ECHO);
// 
int minSpeed=50;
int maxSpeed=900;
int speed=400;
int stepspeed=50;
int dir=0;
// 
unsigned long millisHC04=0;
// переменная для хранения значений джойстика 
int valX = 0; 
// переменная для хранения измеренного расстояния
float dist_cm=0;

void setup(){
  lcd.begin(16,2);
  // очистить
  lcd.clear();
  lcd.setCursor(4,0);
  lcd.print("distance");

  // запуск датчика DHT
  lcd.setCursor(0,0);
  // начальные установки
  motor.setMaxSpeed(900.0);
  motor.setAcceleration(100.0);
  motor.setSpeed(speed);
}
 
void loop(){
   // чтение данных джойстика 
   valX = analogRead(A0); 
   // определение нажатия кнопок
   if(valX<300) { // вправо
      dir=-1;
      motor.setSpeed(speed*dir);
   }
   else if(valX>800) { // влево
      dir=1;
      motor.setSpeed(speed*dir);
   }
   else  { // останов
      dir=0;

   }  
  // движение мотора
  if(dir!=0)
     motor.runSpeed();
  if(millis()- millisHC04>500) {
     // получить данные с дальномера
     dist_cm = ultrasonic.Ranging(CM);
     // вывести на дисплей
     lcd.setCursor(6,1);
     lcd.print("        ");
     lcd.setCursor(6,1);
     lcd.print(dist_cm);
     millisHC04-millis();
  }    
}

   
