// Лаборатория электроники и программирования
// Эксперимент 75
// WEB-клиент на ESP8266  
// Отправка данных MQTT
//

// подключение библиотек
#include <ESP8266WiFi.h>
#include <PubSubClient.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта клиента
WiFiClient wclient;
// данные mqtt
#define mqtt_server  "m24.cloudmqtt.com"
#define mqtt_port 18532 
#define mqtt_user  "cbadnzof" 
#define mqtt_pass  "j63Z6DzKgogS" 
// создание pubsub клиента
PubSubClient client;
// список тем отправки
#define topich "/meteo/humidity"
#define topict "/meteo/temperature"
#define topicp "/meteo/pressure"


// данные, пришедшие из последовательного порта
String inputString = "";        
String inputString1 = ""; 
// строка пришла
boolean stringComplete = false;  



// массив для получения данных от сервера
char response[40];

void setup(void){
  delay(5000);
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("*");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  Serial.print("$");

  client.setClient(wclient);
  client.setServer(mqtt_server, mqtt_port);
  client.setCallback(callback);
  
}

void loop(void){
    if (!client.connected()) {
      reconnect();
    }
    client.loop();
    // проверка данных по последовательному порту
    serialEvent1();
    if (stringComplete) {
       // публикация данных
       publishData(inputString);
       // очистить строку
       inputString = "";
       stringComplete = false;
    }  
    
}
// переподключение к mqtt
void reconnect() {
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...$");
    // Attempt to connect
    if (client.connect("Arduino+WiFi", mqtt_user, mqtt_pass)) {
       Serial.println("Connected to MQTT server$");
       client.setCallback(callback);
       // подписывааемся по топики 
       client.subscribe("/meteo/relay1"); 
       client.subscribe("/meteo/relay2"); 
    } 
    else {
       Serial.println("Could not connect to MQTT server"); 
       Serial.println(" try again in 5 seconds$");
       // Wait 5 seconds before retrying
       delay(5000);
    } 
  }
}
// получение строки по Serial
void serialEvent1() {
  boolean flag1=false; 
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    //Serial.write(inChar);
    if (inChar == '$') {
      stringComplete = true;
      flag1=true;
    }
    else   // добавление в строку
      inputString += inChar;
  }
}

// отправка данных в темы брокера
void publishData(String str) {
    // вывделение данных из строки
    // пришедшей из последовательного порта
    int h1=inputString.indexOf("H1=");
    int h2=inputString.indexOf("&T1=");
    int t1=inputString.indexOf("T1=");
    int t2=inputString.indexOf("&P1=");
    int p1=inputString.indexOf("P1=");
    int p2=inputString.length();
    int h=inputString.substring(h1+3,h2).toInt();
    int t=inputString.substring(t1+3,t2).toInt();
    int p=inputString.substring(p1+3,p2).toInt(); 
    Serial.print("h=");Serial.print(h);
    Serial.print("t=");Serial.print(t);
    Serial.print("p=");Serial.println(p);
    Serial.println("send$");
    client.publish(topich, String(h).c_str(), true);   
    delay(500);
    client.publish(topict, String(t).c_str(), true);  
    delay(500); 
    client.publish(topicp, String(p).c_str(), true);   
}


void callback(char* topic, byte* payload, unsigned int length) {
 Serial.print(topic);
 Serial.print("=");
 for (int i = 0; i < length; i++) {
  char receivedChar = (char)payload[i];
  if (receivedChar == '0')
   Serial.print("1");
  if (receivedChar == '1')
   Serial.print("0");
 }
 Serial.println("$");
}

