// Лаборатория электроники и программирования
// Эксперимент 62
// Cчитывание персональных данных с  RFID-метки.
//

// подключение библиотек
#include <SPI.h>
#include <MFRC522.h>

// Инициализация MFRC522
// константы подключения контактов SS и RST
#define RST_PIN 3     
#define SS_PIN 10    
// Создание экземпляра MFRC522 
MFRC522 mfrc522(SS_PIN, RST_PIN); 
MFRC522::StatusCode status;
MFRC522::MIFARE_Key key;
// массив для заполнения данных
char persData[3][16];
// для смены изображения
unsigned long millis1=0;
int pos=0;
 
void setup() {
   // запуск последовательного порта
   Serial.begin(9600);
   // инициализация SPI 
   SPI.begin(); 
   // инициализация MFRC522
   mfrc522.PCD_Init(); 

}

void loop() {
  if (mfrc522.PICC_IsNewCardPresent()) {
   // чтение карты
   if ( mfrc522.PICC_ReadCardSerial()) {     
      // показать результат чтения UID и тип метки
      Serial.print(F("Card UID:"));
      Serial.print(F("Card UID:")); 
      for (byte i = 0; i < 4; i++) {
         mfrc522.uid.uidByte[i];
         Serial.print(mfrc522.uid.uidByte[i],HEX);
      }
      Serial.println();
      Serial.println(mfrc522.GetStatusCodeName(status));
      // записать пробелы в persData
      for(int i=0;i<3;i++) {
         for(int j=0;j<16;j++)
            persData[i][j]=0x20;
      }
      // чтение данных
      for(int i=0;i<3;i++) {
         // аутентификация карты
         Serial.println(F("Authenticating using key A..."));
         for (byte i = 0; i < 6; i++) 
            key.keyByte[i] = 0xFF;
         status = mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, 4, &key, &(mfrc522.uid)); //line 834 of MFRC522.cpp file
         if (status == MFRC522::STATUS_OK) {
            Serial.print(F("Authentication ok: "));
         }
         // чтение данных с секторов 4,5,6
         byte len = 18;
         status = mfrc522.MIFARE_Read(i+4, persData[i], &len); 
         if (status == MFRC522::STATUS_OK) {
            Serial.print("Reading ok: ");
            Serial.println(mfrc522.GetStatusCodeName(status));
            Serial.print(F("Reading OK! "));
            // распечатать данные сектора
            for (uint8_t j = 0; j < 16; j++) {
               Serial.print(persData[i][j],HEX);Serial.print(" ");
            }
            Serial.println(" "); 
         }
         Serial.println(mfrc522.GetStatusCodeName(status));
         // распечатать данные
         Serial.println("Personal data:");
      }
      // вывод персональных данных
      Serial.println(persData[0]);
      mfrc522.PICC_HaltA();
      mfrc522.PCD_StopCrypto1(); 
   }
  }
  
}

