// Лаборатория электроники и программирования
// Эксперимент 65
// Сервер на  ESP8266  
//

// подключение библиотек
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта сервера
ESP8266WebServer server(80);

// код вывода главной страницы
void handleRoot() {
  server.send(200, "text/html", "Arduino-KIT - <br> Server Arduino+WiFi!");
}
// код вывода страницы about
void handleAbout() {
  server.send(200, "text/html", "<a href='https://arduino-kit.ru/'>Site Arduino-kit</a>");
}
// код вывода  страницы 404
void handleNotFound(){
  String message = "File Not Found\n\n";
  message += "URI: ";
  message += server.uri();
  message += "\nMethod: ";
  message += (server.method() == HTTP_GET)?"GET":"POST";
  message += "\nArguments: ";
  message += server.args();
  message += "\n";
  for (uint8_t i=0; i<server.args(); i++){
    message += " " + server.argName(i) + ": " + server.arg(i) + "\n";
  }
  server.send(404, "text/plain", message);
}

void setup(void){

  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.println("");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

  // главная страница
  server.on("/", handleRoot);
  // страница /about
  server.on("/about", handleAbout);
  // страница 404 - не найдена
  server.onNotFound(handleNotFound);
  // запуск сервера
  server.begin();
  Serial.println("HTTP server started");
}

void loop(void){
  server.handleClient();
}
