// Лаборатория электроники и программирования
// Эксперимент 10
// Подключение 7-сегментного одноразрядного индикатора 
//

// список выводов Arduino для подключения к разрядам a-g
// семисегментного индикатора
int pins[]={11,10,9,8,7,6,5,4};
// значения для вывода цифр 0-9
byte numbers[10] = { B11111100,   // 0
                     B01100000,   // 1
                     B11011010,   // 2
                     B11110010,   // 3
                     B01100110,   // 4
                     B10110110,   // 5
                     B10111110,   // 6
                     B11100000,   // 7
                     B11111110,   // 8
                     B11100110    // 9
};
// переменная для хранения значения текущей цифры
int number=0;

void setup() {
   // Сконфигурировать контакты как выходы
   for(int i=0;i<7;i++)
      pinMode(pins[i],OUTPUT);
}

void loop()  {
   setNumber(number);
   delay(1000);
   // следующая цифра
   number=(number+1)%10;
}

// функция вывода цифры на семисегментный индикатор
void setNumber(int num) {
   for(int i=0;i<7;i++) {
      if(bitRead(numbers[num],7-i)==HIGH) // зажечь сегмент
         digitalWrite(pins[i],HIGH);
      else  // потушить сегмент
         digitalWrite(pins[i],LOW);
   }
}

