// Лаборатория электроники и программирования
// Эксперимент 40
// Сканирование шина I2C 
//


// подключение библиотеки Wire (для I2C)
#include <Wire.h>
// подключение библиотеки для bh1750
#include <BH1750FVI.h>
// создание экземпляра датчика
BH1750FVI myBH1750;
// пины подключения RGB
int pinR=11;
int pinG=9;
int pinB=10;
// границы освещения в норме
const int minL=400;
const int maxL=700;

void setup()
{
   // запуск последовательного порта
   Serial.begin(9600);
   // инициализация дисплея
   // запуск bh1750
   myBH1750.begin();
   // конфигурация пинов RGB
   pinMode(pinR,OUTPUT);
   pinMode(pinG,OUTPUT);
   pinMode(pinB,OUTPUT);
}

void loop() {
   // получение данных с датчика
   myBH1750.setSensitivity(1);
   Serial.print("Light level= ");
   int light=myBH1750.readLightLevel();
   Serial.print(light);
   Serial.println("lx");
   if(light<minL) {
      // от синего к зеленому
      int offset=map(light,0,minL,0,255);
      setRGB(0,255-offset,offset);
   }
   else if(light>minL) {
      // от зеленого к красному
      int offset=map(light,maxL,5000,0,255);
      setRGB(offset,255-offset,0);
   }
   else {
      // зеленый
      setRGB(0,255,0);
   }
   delay(1000);
} 
// установка цвета RGB-светодиода
void setRGB(int r, int g, int b) {
   analogWrite(pinR, r);
   analogWrite(pinG, g);
   analogWrite(pinB, b);
}


