// Лаборатория электроники и программирования
// Эксперимент 41
// Домашняя метеостанция на BMP280 и DHT11 
//


// подключение библиотек
#include <LiquidCrystal.h>
#include "DHT.h"
#include <Wire.h>
#include <SPI.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BMP280.h>
// пин для подключения датчика DHT
#define DHTPIN 12     
// тип датчика DHT
#define DHTTYPE DHT11   // DHT 11 
// создание экземпляров
Adafruit_BMP280 bmp;
LiquidCrystal lcd(8,9,4,5,6,7); 
DHT dht(DHTPIN, DHTTYPE);
// для опроса 
unsigned long millist=0;

void setup()
{
  // подключение последовательного порта
  Serial.begin(9600); 
  // инициализация дисплея
  lcd.begin(16,2);
  // очистить
  lcd.clear();
  // запуск датчиков DHT,BMP20
  dht.begin();
  bmp.begin();
}

void loop() {
  if(millis()-millist>=30000)
     { 
     // получение данных 
     int h = dht.readHumidity();
     int t = bmp.readTemperature();
     int p = bmp.readPressure();     
     // вывод на дисплей
     lcd.clear();
     lcd.setCursor(0,0);
     lcd.print("H="); 
     lcd.print(h);lcd.print("%");
     lcd.setCursor(7,0);
     lcd.print("T="); 
     lcd.print(t);lcd.print("*C");
     lcd.setCursor(0,1);
     lcd.print("P= "); 
     lcd.print(p);lcd.print("Pa");
     //
     millist=millis();
     }
}


