// Лаборатория электроники и программирования
// Эксперимент 58
// Компас на шаговом двигателе и
// датчике HMC5883L
//

// подключение библиотек
#include<AccelStepper.h>
#include "Wire.h"
#include "HMC5883L.h"
// контакты подключения 
#define IN1 10
#define IN2 11
#define IN3 12
#define IN4 13
// создаем экземпляры объектов 
AccelStepper motor(8, IN1, IN3, IN2, IN4);
HMC5883L compass;
// переменные 
int minSpeed=50;
int maxSpeed=900;
int speed=300;
int stepspeed=50;
int dir=0;
//


void setup(){
  Serial.begin(9600);
  Wire.begin();
  // создаем экземпляр HMC5883L библиотеки 
  compass = HMC5883L();  
  // инициализация HMC5883L 
  setupHMC5883L();  
  // начальные установки двигателя
  motor.setMaxSpeed(900.0);
  motor.setAcceleration(100.0);
  motor.setSpeed(200);
}
 
void loop(){
  int heading = getHeading();
  //Serial.println(heading);
   if(heading>3 && heading<=180) { // вправо
      dir=-1;
      motor.setSpeed(speed*dir);
   }
   else if(heading>180 && heading<=356) { // влево
      dir=1;
      motor.setSpeed(speed*dir);
   }
   else  { // останов
      dir=0;
   }    
  // движение мотора
  if(dir!=0)
     motor.runSpeed();

}
 
void setupHMC5883L(){
  // инициализация HMC5883L, и проверка наличия ошибок
  int error;  
  // чувствительность датчика 
  error = compass.SetScale(0.88); 
  if(error != 0) 
    Serial.println(compass.GetErrorText(error));
  // установка режима измерений как Continuous (продолжительный)
  error = compass.SetMeasurementMode(Measurement_Continuous); 
  if(error != 0) 
     Serial.println(compass.GetErrorText(error)); 
}
 
float getHeading(){
  // считываем данные и рассчитываем  направление
  MagnetometerScaled scaled = compass.ReadScaledAxis(); 
  // высчитываем направление 
  float heading = atan2(scaled.YAxis, scaled.XAxis);    
 
  // корректируем значения с учетом знаков
  if(heading < 0) heading += 2*PI;
  if(heading > 2*PI) heading -= 2*PI;
  // переводим радианы в градусы
  return heading * RAD_TO_DEG; 
}


   
