// Лаборатория электроники и программирования
// Эксперимент 67
// Сервер на  ESP8266  
//

// подключение библиотек
#include <ESP8266WiFi.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта сервера
WiFiServer server(80);
 // данные, пришедшие из последовательного порта
String inputString = "";        
String inputString1 = ""; 
// строка пришла
boolean stringComplete = false;  
// пин подключения светодиода 
int pinLed=4;    // GPIO4

void setup(void){
  // конфигурация пина светодиода
  pinMode(pinLed,OUTPUT);
  // и выключить
  digitalWrite(pinLed,LOW);
  delay(5000);
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.println("");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  digitalWrite(pinLed,HIGH);

  // запуск сервера
  server.begin();
  Serial.println("HTTP server started");
  // резервирование 50 bytes для inputString:
  //inputString.reserve(50);
}

void loop(void){
    // проверка прихода строки из последовательного порта
    serialEvent1();
    if (stringComplete) {
       inputString1=inputString;
       Serial.println(inputString1);
       // очистить строку
       inputString = "";
       stringComplete = false;
    }
    // подключение клиента
    WiFiClient client = server.available();
    if (client) {
      Serial.println("new client");
      // конец запроса
      boolean currentLineIsBlank = true;
      while (client.connected()) {
        if (client.available()) {
          char c = client.read();
          Serial.write(c);
          if (c == '\n' && currentLineIsBlank) {
          
            // отправить заголовки и страницу
            client.println("HTTP/1.1 200 OK");
            client.println("Content-Type: text/html");
            client.println("Connection: close");  // the connection will be closed after completion of the response
            //client.println("Refresh: 5");  // refresh the page automatically every 5 sec
            client.println();
            client.println("<!DOCTYPE HTML>");
            client.println("<html>");
            client.println(inputString1);
            client.println("</html>");
            break;
          }
          if (c == '\n') {
            currentLineIsBlank = true;
          } else if (c != '\r') {
            currentLineIsBlank = false;
          }
        }
      }
      delay(1);
      // закрыть соединение
      client.stop();
      Serial.println("client disconnected");
    }    
  
}

void serialEvent1() {
  boolean flag1=false;
  
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    Serial.write(inChar);
    if (inChar == '$') {
      stringComplete = true;
      flag1=true;
    }
    else   // добавление в строку
      inputString += inChar;
  }
}
