// Лаборатория электроники и программирования
// Эксперимент 70
// Загрузка по последовательному порту текста  
// для бегущей строки на 4-х разрядной светодиодной матрице
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>
// пин CS
int pinCS = 10;
// количество матриц по-горизонтали
int numberOfHorizontal = 15; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// строка для вывода
String text = "Arduino-KIT 2019";
// текущее смещение от 0
int offset=32;
// значение скорости
int speed1=500;
 // данные, пришедшие из последовательного порта
String inputString = "";        
// строка пришла
boolean stringComplete = false;  

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(7);
    // запуск последовательного порта 
    Serial.begin(9600);
   // резервирование 30 bytes для inputString:
   inputString.reserve(30);
}

void loop() {
    // проверка прихода строки из последовательного порта
    if (stringComplete) {
       text=inputString;
       offset=32;
       // очистить строку
       inputString = "";
       stringComplete = false;
    }

    // очистка экрана
    matrix.fillScreen(LOW);
    // вывод строки с позиции offset
    for ( int i = 0 ; i < text.length(); i++ ) {
        matrix.setRotation( i, 1 );
        if(i*6+offset>(-6) && i*6+offset<32) {
            matrix.drawChar(i*6+offset, 0, text[i], HIGH, LOW, 1);
        }    
    }
    matrix.write();
    // задержка (скорость)
    delay(speed1);
    // изменение смещения
    offset=offset-1;
    // в начало - позиция 32
    if(offset+text.length()*6==0)
       offset=32;
}
// получение данных по последовательному порту
void serialEvent() {
  boolean flag1=false;
  
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    if (inChar == '#') {
      stringComplete = true;
      flag1=true;
    }
    else   // добавление в строку
      inputString += inChar;
  }
}
