// Лаборатория электроники и программирования
// Эксперимент 77
// Сервер на  ESP8266  
// Отправляем с web-сервера  в интернет-магазин Arduino-kit  
//   отзывы и пожелания о наборе
// Скетч для Arduino 
//

// подключение библиотек
#include <ESP8266WiFi.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта сервера
WiFiServer server(80);


void setup(void){
  delay(5000);
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("*");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());


  // запуск сервера
  server.begin();
  Serial.print("HTTP server started$");
}

void loop(void){

    // подключение клиента
    WiFiClient client = server.available();
    if (client) {
      Serial.println("new client");
      // конец запроса
      boolean currentLineIsBlank = true;
      // собираем данные
      String data="";
      while (client.connected()) {
        if (client.available()) {
          char c = client.read();
          Serial.write(c);
          if (c == '\n' && currentLineIsBlank) {

            // отправить заголовки и страницу
            client.println("HTTP/1.1 200 OK");
            client.println("Content-Type: text/html");
            client.println("Connection: close");  
            client.println();
            client.println("<!DOCTYPE HTML>");
            client.println("<html><head>");
            client.println("<meta charset='UTF-8'>");
            client.println("<meta http-equiv=pragma content=no-cache>");
            client.println("<meta http-equiv=Expires content='-1'>");
            client.println("<meta http-equiv=Cache-Control content=no-cache>");
            client.println("<script>");
            client.println("function viewquestion46() {");
            client.println("var inp = document.getElementsByName('question4'); ");
            client.println("if (inp[4].type == 'radio' && inp[4].checked) ");
            client.println("{document.getElementById('question46').style.visibility='visible';;}");
            client.println("else ");
            client.println("{document.getElementById('question46').style.visibility='hidden';");
            client.println("document.getElementById('question46').value='';}");   
            client.println("}");
            client.println("</script>");
            client.println("</head>");
            client.println("<body>");
            client.println("<form name='survey' method='post' action='http://victorpetin.ru/arduino-kit/survey_to_mail.php'");
            client.println("Оцените книгу '77 ПРОЕКТОВ НА ARDUINO' по 5-бальной шкале <br>");
            client.println("<select name='question1'>");
            client.println("<option disabled>Выберите оценку</option>");
            client.println("<option selected value='5'>5</option>");
            client.println("<option value='4'>4</option>");
            client.println("<option value='3'>3</option>");
            client.println("<option value='2'>2</option>");
            client.println("<option value='1'>1</option>");
            client.println("</select><br> ");
            client.println("Оцените набор-конструктор 'ЛАБОРАТОРИЯ ЭЛЕКТРОНИКИ И ПРОГРАММИРОВАНИЯ НА ОСНОВЕ ARDUINO' по 5-бальной шкале <br>");
            client.println("<select name='question2'>");
            client.println("<option disabled>Выберите оценку</option>");
            client.println("<option selected value='5'>5</option>");
            client.println("<option value='4'>4</option>");
            client.println("<option value='3'>3</option>");
            client.println("<option value='2'>2</option>");
            client.println("<option value='1'>1</option>");
            client.println("</select><br>");
            client.println("Вы посоветуете данный набор-конструктор своим друзьям и знакомым?<br>");
            client.println("<label>Да</label>");
            client.println("<input type='radio' name='question3' value='1' checked>");
            client.println("<label>Нет</label>");
            client.println("<input type='radio' name='question3' value='2'>");
            client.println(" <br>");
            client.println("Какую платформу Вы считаете наиболее перспективной для учебного процесса и DIY: <br>");
            client.println("<label>Arduino</label>");
            client.println("<input type='radio' name='question4' value='1' onchange='viewquestion46();' checked>");
            client.println("<label>Raspberry Pi</label>");
            client.println("<input type='radio' name='question4' value='2' onchange='viewquestion46();'>");
            client.println("<label>BBC: microbit</label>");
            client.println("<input type='radio' name='question4' value='3' onchange='viewquestion46();'>");
            client.println("<label>ESP32</label>");
            client.println("<input type='radio' name='question4' value='4' onchange='viewquestion46();'>");
            client.println("<label>другую</label>");
            client.println("<input type='radio' name='question4' value='5' onclick='viewquestion46();'>");
            client.println("<br>");
            client.println("<input type='text' name='question46' id='question46'>");
            client.println("<br>");
            client.println("Какие пожелания по элементной базе в составе набора? <br>");
            client.println("<textarea rows='10' cols='45' name='question5'></textarea>");
            client.println("<br>");
            client.println("Какие эксперименты добавить? <br>");
            client.println("<textarea rows='10' cols='45' name='question6'></textarea>");
            client.println("<br>");
            client.println("<input type=submit value='Отправить'>");
            client.println("</form>");
            client.println("</body>");
            client.println("</html>");
            client.println("</html>");
            break;
          }
          if (c == '\n') {
            currentLineIsBlank = true;
          } else if (c != '\r') {
            currentLineIsBlank = false;
          }
        }
      }
      delay(1);
      // закрыть соединение
      client.stop();
      Serial.println("client disconnected");
    }    
  
}
