// Лаборатория электроники и программирования
// Эксперимент 58
// Получение положения датчика HMC5883L относительно 
// магнитного полюса Земли в плоскости xy
// 0 градусов - север
//

// Подключение библиотек
#include "Wire.h"
#include "HMC5883L.h"
// Создание объекта 
HMC5883L compass;
 
void setup(){
  Serial.begin(9600);
  Wire.begin();
  // создаем экземпляр HMC5883L библиотеки 
  compass = HMC5883L();  
  // инициализация HMC5883L 
setupHMC5883L();       
}
 
void loop(){
  int heading = getHeading();
  Serial.println(heading);
  delay(250);
}
 
void setupHMC5883L(){
  // инициализация HMC5883L, и проверка наличия ошибок
  int error;  
  // чувствительность датчика 
  error = compass.SetScale(0.88); 
  if(error != 0) 
    Serial.println(compass.GetErrorText(error));
  // установка режима измерений как Continuous (продолжительный)
  error = compass.SetMeasurementMode(Measurement_Continuous); 
  if(error != 0) 
     Serial.println(compass.GetErrorText(error)); 
}
 
float getHeading(){
  // считываем данные и рассчитываем  направление
  MagnetometerScaled scaled = compass.ReadScaledAxis(); 
  // высчитываем направление 
  float heading = atan2(scaled.YAxis, scaled.XAxis);    
 
  // корректируем значения с учетом знаков
  if(heading < 0) heading += 2*PI;
  if(heading > 2*PI) heading -= 2*PI;
  // переводим радианы в градусы
  return heading * RAD_TO_DEG; 
}


   
