// Лаборатория электроники и программирования
// Эксперимент 67
// Web-сервер на ESP8266 для выдачи показаний
// метеостанции на датчикахBMP280 и DHT11 
//
// Arduino - отправка данных на ESP8266
// по последовательному порту serial
//

// подключение библиотек
#include "DHT.h"
#include <Wire.h>
#include <SPI.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>
#include <SoftwareSerial.h>
// пин для подключения датчика DHT
#define DHTPIN 12     
// тип датчика DHT
#define DHTTYPE DHT11   // DHT 11 
// создание экземпляров
Adafruit_BME280 bmp;
SoftwareSerial PCSerial(3, 2); // RX, TX 
DHT dht(DHTPIN, DHTTYPE);
// для опроса 
unsigned long millist=0;
//
String str="";

void setup()
{
  // запуск последовательного порта
  Serial.begin(115200); 
  // запуск порта для USB-TTL
  PCSerial.begin(115200);
  // запуск датчиков DHT,BMP20
  dht.begin();
  bmp.begin();
}

void loop() {
  if(millis()-millist>=10000)
  //if(millis()-millist>=30000)
     { 
     // получение данных 
     int h = dht.readHumidity();
     int t = bmp.readTemperature();
     int p = bmp.readPressure();     
     // отправка в sowtwareserial
     //PCSerial.println("send");
     // отправка в serial
     str="P="+String(p)+" Pa<br>";
     str+="T="+String(t)+" *C<br>";
     str+="H="+String(h)+" %$";
     Serial.print(str);
     // отправка в sowtwareserial
     PCSerial.println(str);
     // новый отсчет 30 сек
     millist=millis();
     }
  // получение ESP8266 -- Arduino
  if (Serial.available()) {
    PCSerial.write(Serial.read());
  }

}


