// Лаборатория электроники и программирования
// Эксперимент 25
// Калькулятор на матричной клавиатуре 
//


// подключение библиотек
#include <LiquidCrystal.h>
#include <Keypad.h>

LiquidCrystal lcd(8,9,4,5,6,7);  
const char keys[4][4]={{'1','2','3','+'},
                       {'4','5','6','-'},
                       {'7','8','9','*'},
                       {'=','0',' ','/'}
};
byte rows[] = {A0, A1, A2, A3 }; 
byte cols[] = {13, 12, 11, 10}; 
Keypad keypad1 = Keypad( makeKeymap(keys), rows, cols, 4, 4); 

// позиция курсора
int pos=0;
int endkey=0;  // 1 - цифра, 2 - действиеб 3 - результат
// буфер для ввода 
char buf[32];

void setup()
{
  lcd.begin(16,2);
  // вывод заставки
  lcd.cursor();
  lcd.setCursor(3,0);
  lcd.print("Calculator");
  lcd.setCursor(2,1);
  lcd.print("Arduino-kit.ru");
  delay(5000);
  lcd.clear();
  for(int i=0;i<32;i++)
     buf[i]=0;
}


void loop() {
  char key = keypad1.getKey();
  if (key){
    // добавить в буфер
    addkey(key);
  }
}
// добавление цифр и действий в буфер
void addkey(char k) {
  switch(k) {
    case '+': if(endkey==1) {
                 buf[pos]=k;tolcd(k);endkey=2;
              }
        break;
    case '-': if(endkey==1) {
                 buf[pos]=k;tolcd(k);endkey=2;
              }
        break;
    case '*': if(endkey==1) {
                 buf[pos]=k;tolcd(k);endkey=2;
              }
        break;
    case '/': if(endkey==1) {
                 buf[pos]=k;tolcd(k);endkey=2;
              }
        break;
    case ' ': pos=max(0,pos-1);tolcd(k);
              pos=pos-1;lcd.setCursor(pos%15,pos/15);
              if(pos==0) 
                 endkey=0;
              else if(buf[pos-1]>=0x30 && buf[pos-1]<=0x39)
                  endkey=1;
              else
                  endkey=2;   
        break;
    case '=': if(endkey==1) {
                 buf[pos]=k;tolcd(k);
                 getsumma();
                 endkey=3;
              }
        break;
    // 0-9    
    default : if(endkey==3) {
                 startover();pos=0;}
              buf[pos]=k;tolcd(k);endkey=1;
        break;
  } 
}
// вывод на экран
void tolcd(char k) {
  lcd.setCursor(pos%15,pos/15);
  lcd.print(k);
  pos=pos+1;
}
// подсчет суммы
void getsumma() {
   String number1="";
   String number2="";
   char d;
   int i;
   int summa;
   // получить первое число
   for(i=0;i<pos;i++) {
     if(buf[i]>=0x30 && buf[i]<=0x39)
        number1+=buf[i];
     else
        break;   
   }
   // действие
   d=buf[i];
   // получить второе число
   for(i=i+1;i<pos;i++) {
     if(buf[i]>=0x30 && buf[i]<=0x39)
        number2+=buf[i];
     else
        break;   
   }
   switch(d) {
      case '+': summa=number1.toInt()+number2.toInt();
         break;
      case '-': summa=number1.toInt()-number2.toInt();
         break;
      case '*': summa=number1.toInt()*number2.toInt();
         break;
      case '/': summa=number1.toInt()/number2.toInt();
         break;
      default: 
         break;      
   }
   lcd.setCursor(pos%15,pos/15);
   lcd.print(summa);
}
// начать сначала - обнуление буфера
// и очищение экрана
void startover() {
   for(int i=0;i<=pos;i++) {
      buf[i]=0;
   }
   lcd.clear();  
}
