// Лаборатория электроники и программирования
// Эксперимент 26
// Управляем движущимся символом на экране дисплея 
//


// подключение библиотеки
#include <LiquidCrystal.h>
// создание экземпляра 
LiquidCrystal lcd(8,9,4,5,6,7);  

// массивы данных для пользовательских символов
byte customChar0[8] = {
	B00000,B00100,B01110,B11111,
	B01110,B00100,B00000,B00000};
byte customChar1[8] = {
	B00000,B00100,B01000,B11111,
	B01000,B00100,B00000,B00000};
byte customChar2[8] = {
	B00000,B00100,B00010,B11111,
	B00010,B00100,B00000,B00000};
byte customChar3[8] = {
  B00000,B00100,B01110,B10101,
	B00100,B00100,B00100,B00000};
byte customChar4[8] = {
	B00000,B00100,B00100,B00100,
	B10101,B01110,B00100,B00000};

// координаты x, y
int posx=0;
int posy=0;  
// движение по x, y
int dirx=0;
int diry=0;
// текущий символ для отображнения
int simv=0;
// для задержки
unsigned long millis1=0;


void setup()
{
  // Создание новых символов новый символ - код 0 (0-7)
  lcd.createChar(0, customChar0);
  lcd.createChar(1, customChar1);
  lcd.createChar(2, customChar2);
  lcd.createChar(3, customChar3);
  lcd.createChar(4, customChar4);  
  // Устанавливаем количество строк и столбцов.
  lcd.begin(16, 2);
  lcd.clear();
  // Печатаем символ c кодом 0
  lcd.write((uint8_t)0);
  //lcd.write((uint8_t)1);
  //lcd.write((uint8_t)2);
  //lcd.write((uint8_t)3);
  //lcd.write((uint8_t)4);
}


void loop() {
   // чтение данных A0 
   int valA0 = analogRead(A0); 
   // определение нажатия кнопки
   if(valA0<100) { // RIGHT
      setVar(1,0,2);
   }
   else if(valA0<200) { // UP
      setVar(0,-1,3);
   }
   else if(valA0<400) { // DOWN
      setVar(0,1,4);
   }
   else if(valA0<600) { // LEFT
      setVar(-1,0,1);
   }
   else if(valA0<800) { // SELECT
      setVar(0,0,0);
   }  
   if(millis()-millis1>1000) {
      // удаление символа из предудущей позиции (запись пробела)
      lcd.setCursor(posy,posx);
      lcd.write(' ');
      // вычисление следующей позиции
      posy=max(min(15,posy+diry),0);
      posx=max(min(1,posx+dirx),0);
      // вывод символа в следующую позицию
      lcd.setCursor(posy,posx);
      lcd.write((uint8_t)simv);
      // пауза (скорость перемещения)
      millis1=millis();
   }
}
// изменение переменных 
// dirx, diry, simv 
void setVar(int dy, int dx, int s) {
  dirx=dx;
  diry=dy;
  simv=s;
}
