// Лаборатория электроники и программирования
// Эксперимент 28
// Вывод спрайта на 4-х разрядную светодиодную матрицу
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>
// пин CS
int pinCS = 10;
// количество матриц по-горизонтали
int numberOfHorizontal = 4; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// изображение
const byte sprite1[8] = {
    0b00111100,
    0b01000010,
    0b10100101,
    0b10000001,
    0b10100101,
    0b10011001,
    0b01000010,
    0b00111100
};

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(6); 
    // очистка экрана
    matrix.fillScreen(LOW); 
    for ( int y = 0; y < 8; y++ ) {
        for ( int x = 0; x < 8; x++ ) {
            // зажигаем x-й пиксель в y-й строке
            matrix.drawPixel(x, y, sprite1[y] & (1<<x));
        }
    }
    // вывод всех пикселей на матрицу
    matrix.write(); 
}

void loop() {;
}
