// Лаборатория электроники и программирования
// Эксперимент 29
// Бегущая строка на 4-х разрядной светодиодной матрице
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>
// пин CS
int pinCS = 10;
// количество матриц по-горизонтали
int numberOfHorizontal = 15; 
// количество матриц по-вертикали
int numberOfVertical = 1; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// строка для вывода
String text = "Arduino-KIT 2019";
// текущее смещение от 0
int offset=32;
// максимальное значение скорости
int maxspeed1=100;
// минимальное значение скорости
int minspeed1=1000;

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(7); 
}

void loop() {
    // очистка экрана
    matrix.fillScreen(LOW);
    // вывод строки с позиции offset
    for ( int i = 0 ; i < text.length(); i++ ) {
        matrix.setRotation( i, 1 );
        if(i*6+offset>(-6) && i*6+offset<32) {
            matrix.drawChar(i*6+offset, 0, text[i], HIGH, LOW, 1);
        }    
    }
    matrix.write();
    // задержка (скорость)
    int speed1=(analogRead(A0),0,1023,minspeed1,maxspeed1);
    delay(speed1);
    // изменение смещения
    offset=offset-1;
    // в начало - позиция 32
    if(offset+text.length()*6==0)
       offset=32;
}
