// Лаборатория электроники и программирования
// Эксперимент 33
// Игра Змейка на 4-x разрядной светодиодной матрице
// 1. Управление движением змейки с помощью джойстика
//

// подключение библиотек
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>

int pinCS = 10;
// количество матриц по-горизонтали
int numberOfHorizontal = 1; 
// количество матриц по-вертикали
int numberOfVertical = 4; 
// создание объекта
Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontal, numberOfVertical);
// пины подключения джойстика
int pinX = A0;
int pinY = A1;
// структура для описания координаты одного звена 8x8
struct Pos {
  int x;
  int y;
};
// массив всех звеньев змейки
Pos snake[40]={{4,4},{4,3},{4,2},{4,1},{4,0},
             {0,16},{0,0},{0,0},{0,0},{0,0},
             {0,0},{0,0},{0,0},{0,0},{0,0},
             {0,0},{0,0},{0,0},{0,0},{0,0},
             {0,0},{0,0},{0,0},{0,0},{0,0},
             {0,0},{0,0},{0,0},{0,0},{0,0},
             {0,0},{0,0},{0,0},{0,0},{0,0},
             {0,0},{0,0},{0,0},{0,0},{0,0}
             };
int offsetsnake=5;

// перемещение по осям x и y и коэффициент (шаг)
int dX=0; // -1, 0, 1
int dY=1; // -1, 0, 1
// скорость
int speedsnake=500;
unsigned long millissnake=0;

void setup() {
    // яркость от 0 до 15
    matrix.setIntensity(8);
    // очищение матрицы
    matrix.fillScreen(LOW); 

}

void loop(){
   // получение смещения по осям x и y
   if (analogRead(pinY) >950) // вправо
      {setdir(0,1);}
   else if (analogRead(pinY)<70) // влево
      {setdir(0,-1);}
   else if (analogRead(pinX)<70) // вверх 
      {setdir(1,0);}
   else if (analogRead(pinX)>950) // вниз 
      {setdir(-1,0);}
   else
      ;
   //// изменение положения змейки
   if(millis()-millissnake>=speedsnake) {
      // стереть предыдущее
      for(int i=0;i<offsetsnake;i++) {
         matrix.drawPixel(snake[i].x, snake[i].y, LOW);
      }
      //// новая позиция для змейки
      // остальные
      for(int i=offsetsnake-1;i>0;i--) {
         snake[i].x=snake[i-1].x;
         snake[i].y=snake[i-1].y;
      }
      // первая
      snake[0].x=snake[0].x+dX;
      snake[0].y=snake[0].y+dY;
      // выход за границу - появление с другой стороны
      if(snake[0].x==8)
        snake[0].x=0;
      if(snake[0].x==-1)
        snake[0].x=7;       
      if(snake[0].y==32)
        snake[0].y=0;
      if(snake[0].y==-1)
        snake[0].y=31;       
      // нарисовать новое
      for(int i=0;i<offsetsnake;i++) {
         matrix.drawPixel(snake[i].x, snake[i].y, HIGH); 
      }
      // вывод всех пикселей на матрицы
      matrix.write(); 
      millissnake=millis(); 
   }

}
// установить новое направление движения
void setdir(int x,int y) {
   int x1,y1;
   x1=x;y1=y;
   if((dX+x)==0 && abs(x)>0)
     {y1=y;x1=dX;}
   if((dY+y)==0 && abs(y)>0)
     {x1=x;y1=dY;}
   // установить
   dX=x1;dY=y1;  
}



