// Лаборатория электроники и программирования
// Эксперимент 45
// Часы на DS3231 и ЖК дисплее LCD Keypad shield
// 

// подключение библиотек
#include <Wire.h>
#include <DS1307RTC.h>
#include <Time.h>
#include <TimeLib.h>
#include <LiquidCrystal.h>
// создание экземпляра дисплея
LiquidCrystal lcd(8,9,4,5,6,7);
// переменная времени-даты
tmElements_t datetime;  
// массив дней недели
String weekdays[]={
     {"  Sunday  "},{"  Monday  "},{" Tuesday  "},{"Wednesday "},
     {" Thursday "},{"  Friday  "},{" Saturday "}
};
// для смены данных второй строки
boolean week=false;
unsigned long millis1=0; 

void setup() {
   Serial.begin(9600); 
   // запуск дисплея
   lcd.begin(16,2);
   // вывод заставки
   lcd.setCursor(3,0);
   lcd.print("Clock DS3231");
   lcd.setCursor(2,1);
   lcd.print("Arduino-kit.ru");
   delay(3000);
   lcd.clear();
}

void loop() {
   // получение данных из ds3231
   if (RTC.read(datetime))  {
      // время HH:mm:ss
      lcd.setCursor(4,0);
      lcd.print(print2(datetime.Hour, ":"));
      lcd.print(print2(datetime.Minute, ":"));
      lcd.print(print2(datetime.Second, " "));
      // дата или день недели
      lcd.setCursor(3,1);
      Serial.println();
      if(week) { // день недели
         lcd.print(weekdays[datetime.Wday]);
      }
      else {    // дата dd/mm/YYYY
         lcd.print(print2(datetime.Day, "/"));
         lcd.print(print2(datetime.Month, "/"));
         lcd.print(tmYearToCalendar(datetime.Year));
      }
      // изменение week каждые 5 секунд
      if(millis()-millis1>5000) {
         week=!week;
         millis1=millis();
      }
   }
   else {
         lcd.print("error");
         delay(5000);
   }
   delay(1000);
}
String print2(int nn,String str) {
   String s="";
   if (nn >= 0 && nn < 10) 
      { s=s+"0";}
   s=s+String(nn);
   s=s+str;
   return s;
}

