// Лаборатория электроники и программирования
// Эксперимент 60
// Организация контроля доступа по RFID-меткам
//

// подключение библиотек
#include <LiquidCrystal.h>
#include <SPI.h>
#include <MFRC522.h>
// пин для подключения реле
#define RELAY_RC522_PIN 2
// пин для подключения динамика
#define SPEAKER_PIN A0

// уровни для включения/выключения реле
#define RELAY_ON 0
#define RELAY_OFF 1
// Инициализация MFRC522
// константы подключения контактов SS и RST
#define RST_PIN 3     
#define SS_PIN 10    
// Создание экземпляра MFRC522 
MFRC522 mfrc522(SS_PIN, RST_PIN); 
// создаем экземпляр объекта дисплея 
LiquidCrystal lcd(8,9,4,5,6,7); 

// массив разрешенных uid
byte uidok[][4]={
                 {0xE0, 0x2A, 0x87, 0x1B},
                 {0xD9, 0xFA, 0x90, 0x55},
                 {0x36, 0xAE, 0x59, 0xA5 }
};
 
void setup() {
   // инициализация дисплея  
   lcd.begin(16,2);
   // очистить
   lcd.clear();
   // инициализация SPI 
   SPI.begin(); 
   // инициализация MFRC522
   mfrc522.PCD_Init(); 
   // сконфигурировать вывод реле как OUTPUT
   pinMode(RELAY_RC522_PIN,OUTPUT);
   // и выключить
   digitalWrite(RELAY_RC522_PIN, RELAY_OFF);
   // сконфигурировать вывод динамика
   pinMode(SPEAKER_PIN,OUTPUT);

}

void loop() {
  if (mfrc522.PICC_IsNewCardPresent()) {
   // чтение карты
   if ( mfrc522.PICC_ReadCardSerial()) {     
      // показать результат чтения UID и тип метки
      Serial.print(F("Card UID:"));
      if(compare_uid(mfrc522.uid.uidByte, mfrc522.uid.size)) {
          lcd.setCursor(4,1);
          lcd.print("OK !!!");
          tone(SPEAKER_PIN,494,300);
          delay(500);
          tone(SPEAKER_PIN,440,200);
          // включить реле
          digitalWrite(RELAY_RC522_PIN, RELAY_ON);
          delay(4000);
          digitalWrite(RELAY_RC522_PIN, RELAY_OFF);
      } else {
          lcd.setCursor(4,1);
          lcd.print("NO !!!");
          tone(SPEAKER_PIN,293,300);
          delay(500);
          tone(SPEAKER_PIN,329,500);
          delay(1000);
      }
   }
  }
}
// поиск считанного uid в списке разрешенных
boolean compare_uid(byte *buffer, byte bufferSize) {
int bytes_ok=0;
   lcd.clear();
   lcd.setCursor(0,0);
   for(int i1=0;i1<3;i1++) {
      bytes_ok=0;
      for (byte i2 = 0; i2 < 4; i2++) {
         lcd.print(buffer[i2] < 0x10 ? " 0" : " ");
         lcd.print(buffer[i2], HEX);
         if(buffer[i2]== uidok[i1][i2]) {
            bytes_ok= bytes_ok+1;
         }
      }
      if(bytes_ok==4) {
         return true;
      }
   }
   return false;
}

