// Лаборатория электроники и программирования
// Эксперимент 70
// Сервер на  ESP8266  
// Отправка данных получаемых со страницы web-сервера
// по последовательному порту на Arduino для
// текста бегущей строки на на 4-х разрядной светодиодной матрице
//

// подключение библиотек
#include <ESP8266WiFi.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта сервера
WiFiServer server(80);
 // данные, пришедшие из последовательного порта
String inputString = "";        
String inputString1 = ""; 
// строка пришла
boolean stringComplete = false;  

void setup(void){
  delay(5000);
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("*");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());


  // запуск сервера
  server.begin();
  Serial.print("HTTP server started$");
}

void loop(void){

    // подключение клиента
    WiFiClient client = server.available();
    if (client) {
      Serial.println("new client");
      // конец запроса
      boolean currentLineIsBlank = true;
      // собираем данные
      String data="";
      while (client.connected()) {
        if (client.available()) {
          char c = client.read();
          data+=c;
          Serial.write(c);
          if (c == '\n' && currentLineIsBlank) {
            // анализ данных запроса и отправка данных на Arduino
            String toArduino="*";
            int n1=data.indexOf("?text1=");
            int n2=data.indexOf("&send1");
            toArduino+=data.substring(n1+7,n2)+"$";
            Serial.print(toArduino+String(n1)+" "+String(n2));
            // отправить заголовки и страницу
            client.println("HTTP/1.1 200 OK");
            client.println("Content-Type: text/html");
            client.println("Connection: close");  // the connection will be closed after completion of the response
            client.println();
            client.println("<!DOCTYPE HTML>");
            client.println("<html>");
            client.println("<form name='form1' id='form1' action='' method='GET'>");
            client.println("<br> Text for the ticker <input  name='text1' >");
            client.println("<br> <input type='submit' name='send1' value='Send' >");
            client.println("</form>");
            client.println("</html>");
            break;
          }
          if (c == '\n') {
            currentLineIsBlank = true;
          } else if (c != '\r') {
            currentLineIsBlank = false;
          }
        }
      }
      delay(1);
      // закрыть соединение
      client.stop();
      Serial.println("client disconnected");
    }    
  
}


