// Лаборатория электроники и программирования
// Эксперимент 71
// WEB-клиент на ESP8266  
// Отправка данных на сайт Народный мониторинг
// www,narodmon.ru
// получение данных отправки по последовательному 
//

// подключение библиотек
#include <ESP8266WiFi.h>
// данные SSID и пароль точки доступа
const char* ssid     = "Kassa1";
const char* password = "12345678";
// создание объекта клиента
WiFiClient client;
 // данные, пришедшие из последовательного порта
String inputString = "";        
String inputString1 = ""; 
// строка пришла
boolean stringComplete = false;  
// сервер Народного мониторинга
char server[] = "www.narodmon.ru";    
// массив для получения данных от сервера
char response[40];

void setup(void){
  delay(5000);
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("*");

  // Подсоединение к точке доступа
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

}

void loop(void){
    serialEvent1();
    if (stringComplete) {
       // отправить данные на сайт
       sendDataNarodmon(inputString);
       // очистить строку
       inputString = "";
       stringComplete = false;
    }  
}
// получение строки по Serial
void serialEvent1() {
  boolean flag1=false;
  
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    Serial.write(inChar);
    if (inChar == '$') {
      stringComplete = true;
      flag1=true;
    }
    else   // добавление в строку
      inputString += inChar;
  }
}

// отправка данных на сайт Народного мониторинга
void sendDataNarodmon(String str) {
   if (client.connect(server, 80)) {
      //// отправка данных на сервер narodmon.ru
      Serial.print(str);
      client.println("GET "+str+" HTTP/1.1");
      client.println("Host: www.narodmon.ru");
      client.println("Connection: close");
      client.println();
      // получение ответа
      unsigned long previos=millis();
      for(int i=0;i<40;i++)
         response[i]=0; 
      int x=0;int f=0;
      do{
         if(client.available() > 0) { 
            // получать данные из ESP8266
            char s = client.read();
            if(s=='#') 
               f=1;
            if(f==1) {
               response[x]=s;
               //Serial.print(response[x]);
               x++;
            }
         Serial.write(s);
         }
      }
      while((millis() - previos) < 5000);
      Serial.println(response);
      client.stop();
   } 
   else {
     // нет соединения
     Serial.println("connection failed");
     client.stop();
   }
  
}

