// Лаборатория электроники и программирования
// Эксперимент 74
// 
// прием и исполнение на домашней
//   метеостанции команд управления отправляемых 
//   с сайта Народного мониторинга 
// (приходящих по последовательному порту с ESP8266)
//


// подключение библиотек
#include "DHT.h"
#include <Wire.h>
#include <SPI.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>
// пин для подключения датчика DHT
#define DHTPIN 10     
// тип датчика DHT
#define DHTTYPE DHT11   // DHT 11 
// создание экземпляров
Adafruit_BME280 bmp;
DHT dht(DHTPIN, DHTTYPE);
// для опроса
unsigned long millissend=0;
unsigned long pauseseconds=10;
// ID - устройства в Народном мониторинге
String IDstr="441369430175";
// контакты подключения реле
const int pinRelay1=7;
const int pinRelay2=6;
// данные, пришедшие из последовательного порта
String inputString = "";        
// строка пришла
boolean stringComplete = false;  


void setup()
{
  // подключение последовательного порта
  Serial.begin(115200); 
   // конфигурация пинов 
   pinMode(pinRelay1,OUTPUT);
   pinMode(pinRelay2,OUTPUT);
   // начальная установка
   digitalWrite(pinRelay1,HIGH);
   digitalWrite(pinRelay2,HIGH);

  // запуск датчиков DHT,BMP20
  dht.begin();
  bmp.begin();
}

void loop() {
    // проверка прихода строки из последовательного порта
    if (stringComplete) {
       command();
       // очистить строку
       inputString = "";
       stringComplete = false;
    }

  // ждем время паузы
  if(millis()-millissend>=1000) {
     pauseseconds--;
     if(pauseseconds==0) {
        // получение данных 
        int h = dht.readHumidity();
        int t = bmp.readTemperature();
        float p = bmp.readPressure()/133.32;     
        // формирование строки
        String str="/get?ID="+IDstr;
        str=str+"&H1="+String(h);
        str=str+="&T1="+String(t);
        str=str+="&P1="+String(p);
        str=str+="$";
        // отправка в последовательный порт
        Serial.print(str);
        //
        //pauseseconds=20;
        pauseseconds=300;
        }

     millissend=millis();
  }
}
// получение данных по последовательному порту
void serialEvent() {
  boolean flag1=false;
  
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    if (inChar == '$') {
      stringComplete = true;
      flag1=true;
    }
    else   // добавление в строку
      inputString += inChar;
  }
}
// проверка пришедших с сервера команд
void command() {
     //
    if(inputString.indexOf("relay1=1")!=-1) {
       digitalWrite(pinRelay1,LOW);
    }
    if(inputString.indexOf("relay1=0")!=-1) {
       digitalWrite(pinRelay1,HIGH);
    }
    if(inputString.indexOf("relay2=1")!=-1) {
       digitalWrite(pinRelay2,LOW);
    }
    if(inputString.indexOf("relay2=0")!=-1) {
       digitalWrite(pinRelay2,HIGH);
    }
    
}

