// Лаборатория электроники и программирования
// Эксперимент 48
// Часы на DS3231 и ЖК дисплее LCD Keypad shield
// Будильники в EEPROM
//

// подключение библиотек
#include <Wire.h>
#include <DS1307RTC.h>
#include <Time.h>
#include <TimeLib.h>
#include <LiquidCrystal.h>
#include <EEPROM.h>
// создание экземпляра дисплея
LiquidCrystal lcd(8,9,4,5,6,7);
// переменная времени-даты
tmElements_t datetime;  
// массив дней недели
String weekdays[]={
     {"  Sunday  "},{"  Monday  "},{" Tuesday  "},{"Wednesday "},
     {" Thursday "},{"  Friday  "},{" Saturday "}
};
// для смены данных второй строки
boolean week=false;
unsigned long millis1=0;
// структура, описывающая будильник
struct ALARM{
  int Hour;       // час срабатывания будильника
  int Minute;     // минута срабатывания будильника
  int Day;         // день срабатывания будильника
  int Month;       // месяц срабатывания будильника
  int Year;        // год срабатывания будильника
  boolean repeat;  // true – повторять, false -одноразово 
  int wdays[7];    // дни недели
};
// список будильников
ALARM alarms[10];
int countalarms=0;
// будильник работает?
boolean alarmyes=false;
// пин подключения динамика
int pinSpeaker=10;
// данные, пришедшие из последовательного порта
String inputString = "";        
// строка пришла
boolean stringComplete = false;  

void setup() {
   Serial.begin(9600); 
   // запуск дисплея
   lcd.begin(16,2);
   // вывод заставки
   lcd.setCursor(3,0);
   lcd.print("Clock DS3231");
   lcd.setCursor(2,1);
   lcd.print("Arduino-kit.ru");
   delay(3000);
   lcd.clear();
   // пин динамика
   pinMode(pinSpeaker,OUTPUT);
   // подгрузка будильников из EEPROM
   getAlarms();
   // резервирование 50 bytes для inputString:
   inputString.reserve(50);

}

void loop() {
    // проверка прихода строки из последовательного порта
    if (stringComplete) {
       Serial.println(inputString);
       // обработка строки
       parse();
       // очистить строку
       inputString = "";
       stringComplete = false;
       Serial.println("wait.....");
    }
   // выключение будильника
   if(alarmyes==true) {
      if(analogRead(A0)<100) { // кнопка RIGHT нажата?
         alarmyes=false;
         noTone(pinSpeaker);
         Serial.println("ALARM STOP");   
      }
   }
   
   // получение данных из ds3231
   if (RTC.read(datetime))  {
      // время HH:mm:ss
      lcd.setCursor(4,0);
      lcd.print(print2(datetime.Hour, ":"));
      lcd.print(print2(datetime.Minute, ":"));
      lcd.print(print2(datetime.Second, " "));
      // дата или день недели
      lcd.setCursor(3,1);
      if(week) { // день недели
         lcd.print(weekdays[datetime.Wday]);
      }
      else {    // дата dd/mm/YYYY
         lcd.print(print2(datetime.Day, "/"));
         lcd.print(print2(datetime.Month, "/"));
         lcd.print(tmYearToCalendar(datetime.Year));
      }
      // изменение week каждые 5 секунд
      if(millis()-millis1>5000) {
         week=!week;
         millis1=millis();
      // проверка времение срабатывания будильника
      isalarm();
      }
   }
   else {
         lcd.print("error");
         delay(5000);
   }
   delay(1000);
}
String print2(int nn,String str) {
   String s="";
   if (nn >= 0 && nn < 10) 
      { s=s+"0";}
   s=s+String(nn);
   s=s+str;
   return s;
}
// проверка времение срабатывания будильника
void isalarm() {
   // проход по всем будильникам
   for(int i=0;i<countalarms;i++) {
       if(alarms[i].repeat==false) { //одноразовый
          if(tmYearToCalendar(datetime.Year)==alarms[i].Year &&
             datetime.Month==alarms[i].Month &&
             datetime.Day==alarms[i].Day &&
             datetime.Hour==alarms[i].Hour &&
             datetime.Minute==alarms[i].Minute &&
             datetime.Second<3) {
             tone(pinSpeaker,349,30000);
             alarmyes=true;  
             Serial.println("ALARM OK");   
          }
       }
       else {
          if(alarms[i].wdays[datetime.Wday]==1 &&
             datetime.Hour==alarms[i].Hour &&
             datetime.Minute==alarms[i].Minute &&
             datetime.Second<3) {
             tone(pinSpeaker,349,30000);
             alarmyes=true;     
             Serial.println("ALARM OK1");   
          }
       }   
   }
}
// подгрузка будильников из EEPROM
void getAlarms() {
   countalarms=EEPROM.read(0);
   for(int i=0;i<countalarms;i++) {
        alarms[i].Hour=EEPROM.read(i*14+1);
        alarms[i].Minute=EEPROM.read(i*14+2);
        alarms[i].Day=EEPROM.read(i*14+3);
        alarms[i].Month=EEPROM.read(i*14+4);
        alarms[i].Year=(EEPROM.read(i*14+5)<<8)+EEPROM.read(i*14+6);
        alarms[i].repeat=EEPROM.read(i*14+7);
        for(int j=0;j<7;j++) {
           alarms[i].wdays[j]=EEPROM.read(i*14+8+j);
        }
    } 
   for(int i=0;i<countalarms;i++) {
        Serial.print(alarms[i].Hour);Serial.print(" ");
        Serial.print(alarms[i].Minute);Serial.print(" ");
        Serial.print(alarms[i].Day);Serial.print(" ");
        Serial.print(alarms[i].Month);Serial.print(" ");
        Serial.print(alarms[i].Year);Serial.print(" ");
        Serial.print(alarms[i].repeat);Serial.print(" ");
        for(int j=0;j<7;j++) {
           Serial.print(alarms[i].wdays[j]);Serial.print(" ");
        }
        Serial.println(" ");
    } 
    
}

// получение данных по последовательному порту
void serialEvent() {
  boolean flag1=false;
  
  while (Serial.available() && flag1==false) {
    // получить байт:
    char inChar = (char)Serial.read();
    // добавление в строку
    inputString += inChar;
    if (inChar == '$') {
      stringComplete = true;
      flag1=true;
    }
  }
}
// парсинг поступивших данных
void parse() {
   int data[15];
   int index=0;
   String str1="";
   unsigned int count;
   
   // очистить
   for(int i=0;i<15;i++) {
      data[i]=0;
   }
   for(int i=0;i<inputString.length();i++) {
      if(inputString[i]==';' || inputString[i]=='$') {
         data[index]=str1.toInt();
         str1="";
         index++;
      }
      else {
         str1=str1+inputString[i];
      }         
   }
   // выполнить команды
   count=EEPROM.read(0);
   switch(data[0]) {
      case 1:  Serial.println("OK");
               // добавление будильника
               count=EEPROM.read(0);
               EEPROM.write(count*14+1,data[1]);
               EEPROM.write(count*14+2,data[2]);
               EEPROM.write(count*14+3,data[3]);
               EEPROM.write(count*14+4,data[4]);
               EEPROM.write(count*14+5,highByte(data[5]));
               EEPROM.write(count*14+6,lowByte(data[5]));
               EEPROM.write(count*14+7,data[6]);
               EEPROM.write(count*14+8,data[7]);
               EEPROM.write(count*14+9,data[8]);
               EEPROM.write(count*14+10,data[9]);
               EEPROM.write(count*14+11,data[10]);
               EEPROM.write(count*14+12,data[11]);
               EEPROM.write(count*14+13,data[12]);
               EEPROM.write(count*14+14,data[13]);
               count++;
               EEPROM.write(0,count);
               Serial.println("add alarm");  
               getAlarms();            
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 2:  Serial.println("OK");
               // удалить если <= count
               if(data[1]<=count && data[1]>0) {
                  // перенести будильники от count до data[1]
                  for(int i=data[1];i<count;i++) {
                     for(int j=1;j<15;j++) {
                        EEPROM.write((i-1)*14+j,EEPROM.read(i*14+j));
                     }
                  }
                  count--;
                  EEPROM.write(0,count);
                  Serial.println("delete alarm"); 
                  getAlarms();
               }
               else {
                  Serial.println("delete alarm ERROR !"); 
               }
               Serial.println("delete alarm");              
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 3:  Serial.println("OK");
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 4:  Serial.println("OK");
               for(int i=0;i<count;i++) {
                  Serial.print(EEPROM.read(i*14+1));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+2));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+3));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+4));Serial.print(" ");
                  Serial.print((EEPROM.read(i*14+5)<<8)+EEPROM.read(i*14+6));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+7));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+8));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+9));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+10));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+11));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+12));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+13));Serial.print(" ");
                  Serial.print(EEPROM.read(i*14+14));Serial.print(" ");
                  Serial.println();
               }
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      case 5:  Serial.println("OK");
               count=0;
               EEPROM.write(0,count);
               Serial.println("clear alarms"); 
               getAlarms();             
               Serial.print("all alarms = ");Serial.println(count);              
         break;
      default:  Serial.println("ERROR");
         break;            
   }   
}

