

//  Приём купурь и манет с зачеслением на карту пакупателя.
// Компоненты:
// корпус пластиковвый.
// купюроприёмник ICT A7.
// Манетоприёмник CH-926.
// Плата Arduino UNO.
// Блок питания: компьютерный.  
// Дисплей WH1602 I2C.
// RFID-считаватель RC522.
// Модиль RTC DS3231(часы ряльного времени.
// 
//
//
//

//подключение библиотек.
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
#include <Time.h>
#include <TimeLib.h>
#include <DS1307RTC.h>
#include <SPI.h>
#include <MFRC522.h>

//создание объектов.
LiquidCrystal_I2C lcd(0x27, 16, 2);
MFRC522 mfrc522(10, 9); 
// пременая даты и времени.
tmElements_t tm;

// код наших карт 3579
byte cardKod[4] = {0x34,0x35,0x37,0x39};  
// для сохранеия UID 
byte cardUID[4] = {0,0,0,0};
// баланс карты
unsigned int balance=0; 
//
byte buffer1[18];
byte block = 5;
byte len = 18;
MFRC522::StatusCode status;
MFRC522::MIFARE_Key key;
// подсчёт  импульсов для купюраприёмника.
int pulse1=0;
unsigned long millis1=0;
//подчёт импульсов для монетаприёмика.
int pulse2=0;
unsigned long millis2=0;
// для вывода времени и даты.
unsigned long millist=0;
unsigned long millislcd=0;
// принитая сумма.
unsigned int summa=0;


void setup() {
   // Запустить последовательный порт для отладки
   Serial.begin(9600);
   // Запуск RFID считывателя.
   SPI.begin();               
   mfrc522.PCD_Init();
   // назначить прерывание для купюроприёмника
   attachInterrupt(0,coin1,FALLING);
   // назначить прерывание для монетаприёмника
   attachInterrupt(1,coin2,FALLING);
   // запук дисплея.
   lcd.begin();
   //включить подстветку дисплея.
   lcd.backlight();
   //вывисте заголовок 
   header();
   //отчистим дисплей
   lcd.clear();
   Serial.println("start!!!");
}

void loop() {
   // получить время и дату и вывести на дисплей.
   // делаем один раз в секунду.
   if(millis()-millist>=1000) {  
       
      // получиние даты и времени с микросхемы RTC.
      if (RTC.read(tm)) {
         // вывод на дисплей.
         if(millis()-millislcd>=6000) {
             millislcd=millis();
         }
         else if(millis()-millislcd>=4000) {
             Dt_Tm_lcd ();
         }
         else {
            if(summa>0)
               {Summa_lcd(summa);}
            else
              {Str_lcd();}
         }
      }   
      millist=millis();
   }
   // ожидание окончания приёма купюры.
   if(pulse1>0 && millis()-millis1>400 && millis()>millis1)
      {  
      Serial.print("kup=");
      Serial.print(pulse1*10);
      Serial.println("Rub");
      summa=summa+pulse1*10;
      Serial.print("summa=");
      Serial.print (summa);
      Serial.println("Rub");
      Serial.println();
      pulse1=0;
      }   
   // ожидание окончания приёма монеты.
   if(pulse2>0 && millis()-millis2>400 && millis()>millis2)
      {  
      Serial.print("Monet=");
      Serial.print(pulse2*1);
      Serial.println("Rub");
      Serial.println();
      pulse2=0;
      }   
  // Проверка поднесена ли карта
  if ( mfrc522.PICC_IsNewCardPresent()) {
     // Считываем инфо о карте.
     if ( mfrc522.PICC_ReadCardSerial()) {   
         // сохранить UID
         Serial.print(F("Card UID:")); 
         for (byte i = 0; i < 4; i++) {
             cardUID[i]=mfrc522.uid.uidByte[i];
             Serial.print(cardUID[i],HEX);
         }
     // проверить на наличие в сестеме данных.
     if(!isstrangekarta()) {
         Serial.println("Strange karta!");
         setkartanostrange();
     }
    
     //// Считать баланс ////
     if(getbalance()==true) {
        if(summa>0){
           // занести сумму на карту///////
           if(addbalance (balance+summa)==true){
              lcd.setCursor(0,1); 
              lcd.print("                ");
              lcd.setCursor(0,1); 
              lcd.print("Load ");
              lcd.print(summa);
              lcd.print(" rub"); 
              delay(1000);
              summa=0;
              getbalance();    
           }
           else {
              lcd.setCursor(0,1); 
              lcd.print("                ");
              lcd.setCursor(0,1); 
              lcd.print("not success ");
           }
        }
        delay(1000);          
     }
     mfrc522.PICC_HaltA();
     mfrc522.PCD_StopCrypto1();
     // Отчистка 1 строки.
     clear_lcd_str1 ();
     }
  }
      
}
